/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.block.BlockAutomationInterface;
import com.blakebr0.extendedcrafting.block.BlockCompressor;
import com.blakebr0.extendedcrafting.block.BlockCraftingCore;
import com.blakebr0.extendedcrafting.block.BlockEnderCrafter;
import com.blakebr0.extendedcrafting.block.BlockLamp;
import com.blakebr0.extendedcrafting.block.BlockPedestal;
import com.blakebr0.extendedcrafting.block.BlockTrimmed;
import com.blakebr0.extendedcrafting.block.craftingtable.BlockAdvancedTable;
import com.blakebr0.extendedcrafting.block.craftingtable.BlockBasicTable;
import com.blakebr0.extendedcrafting.block.craftingtable.BlockEliteTable;
import com.blakebr0.extendedcrafting.block.craftingtable.BlockUltimateTable;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipe;
import com.blakebr0.extendedcrafting.crafting.CompressorRecipe;
import com.blakebr0.extendedcrafting.tile.TileAutomationInterface;
import com.blakebr0.extendedcrafting.tile.TileCompressor;
import com.blakebr0.extendedcrafting.tile.TileCraftingCore;
import com.blakebr0.extendedcrafting.tile.TileEnderCrafter;
import com.blakebr0.extendedcrafting.tile.TilePedestal;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.MethodsReturnNonnullByDefault;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

@MethodsReturnNonnullByDefault
public class WailaDataProvider
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)TooltipProvider.of((stack, tooltip, data, config) -> tooltip.add(Utils.localize((String)("tooltip.ec.lamp_" + BlockLamp.Type.byMetadata(data.getMetadata()).func_176610_l())))), BlockLamp.class);
        registrar.registerBodyProvider((IWailaDataProvider)TooltipProvider.of((stack, tooltip, data, config) -> tooltip.add(Utils.localize((String)("tooltip.ec.trimmed_" + BlockTrimmed.Type.byMetadata(data.getMetadata()).func_176610_l())))), BlockTrimmed.class);
        registrar.registerBodyProvider((IWailaDataProvider)WailaDataProvider.checkTile(TilePedestal.class, (stack, tooltip, data, config, pedestal) -> {
            ItemStack result = pedestal.getStack();
            if (!result.func_190926_b()) {
                tooltip.add(result.func_82833_r());
            }
        }), BlockPedestal.class);
        registrar.registerBodyProvider((IWailaDataProvider)WailaDataProvider.checkTile(TileCraftingCore.class, (stack, tooltip, data, config, core) -> {
            CombinationRecipe recipe;
            ItemStack output;
            if (ModConfig.confEnergyInWaila) {
                tooltip.add(Utils.format((Object)core.getEnergy().getEnergyStored()) + " FE");
            }
            ItemStack itemStack = output = (recipe = core.getRecipe()) == null ? ItemStack.field_190927_a : recipe.getOutput();
            if (!output.func_190926_b()) {
                tooltip.add(Utils.localize((String)"tooltip.ec.crafting", (Object[])new Object[]{output.func_190916_E(), output.func_82833_r()}));
            }
        }), BlockCraftingCore.class);
        registrar.registerBodyProvider((IWailaDataProvider)WailaDataProvider.checkTile(TileAutomationInterface.class, (stack, tooltip, data, config, auto) -> {
            ItemStack result;
            if (ModConfig.confEnergyInWaila) {
                tooltip.add(Utils.format((Object)auto.getEnergy().getEnergyStored()) + " FE");
            }
            if (!(result = auto.getResult()).func_190926_b()) {
                tooltip.add(Utils.localize((String)"tooltip.ec.crafting", (Object[])new Object[]{result.func_190916_E(), result.func_82833_r()}));
            }
        }), BlockAutomationInterface.class);
        registrar.registerBodyProvider((IWailaDataProvider)WailaDataProvider.checkTile(TileEnderCrafter.class, (stack, tooltip, data, config, crafter) -> {
            ItemStack result = crafter.getResult();
            if (!result.func_190926_b()) {
                tooltip.add(Utils.localize((String)"tooltip.ec.output", (Object[])new Object[]{result.func_190916_E(), result.func_82833_r()}));
            }
        }), BlockEnderCrafter.class);
        registrar.registerBodyProvider((IWailaDataProvider)WailaDataProvider.checkTile(TileCompressor.class, (stack, tooltip, data, config, compressor) -> {
            CompressorRecipe recipe;
            ItemStack output;
            if (ModConfig.confEnergyInWaila) {
                tooltip.add(Utils.format((Object)compressor.getEnergy().getEnergyStored()) + " FE");
            }
            ItemStack itemStack = output = (recipe = compressor.getRecipe()) == null ? ItemStack.field_190927_a : recipe.getOutput();
            if (!output.func_190926_b()) {
                tooltip.add(Utils.localize((String)"tooltip.ec.crafting", (Object[])new Object[]{output.func_190916_E(), output.func_82833_r()}));
            }
        }), BlockCompressor.class);
        registrar.registerBodyProvider((IWailaDataProvider)WailaDataProvider.table(1), BlockBasicTable.class);
        registrar.registerBodyProvider((IWailaDataProvider)WailaDataProvider.table(2), BlockAdvancedTable.class);
        registrar.registerBodyProvider((IWailaDataProvider)WailaDataProvider.table(3), BlockEliteTable.class);
        registrar.registerBodyProvider((IWailaDataProvider)WailaDataProvider.table(4), BlockUltimateTable.class);
    }

    private static TooltipProvider table(int tier) {
        return TooltipProvider.of((stack, tooltip, data, config) -> tooltip.add(Utils.localize((String)"tooltip.ec.tier", (Object[])new Object[]{tier})));
    }

    private static <T extends TileEntity> TooltipProvider checkTile(Class<T> clazz, TileBodyConsumer<T> consumer) {
        return TooltipProvider.of((stack, tooltip, data, config) -> {
            TileEntity tile = data.getTileEntity();
            if (clazz.isInstance(tile) && !tile.func_145837_r()) {
                consumer.getWailaBody(stack, tooltip, data, config, (TileEntity)clazz.cast(tile));
            }
        });
    }

    public static class TooltipProvider
    implements IWailaDataProvider {
        private final BodyConsumer consumer;

        private TooltipProvider(BodyConsumer consumer) {
            this.consumer = consumer;
        }

        public static TooltipProvider of(BodyConsumer consumer) {
            return new TooltipProvider(consumer);
        }

        @Nonnull
        public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            this.consumer.getWailaBody(itemStack, tooltip, accessor, config);
            return tooltip;
        }
    }

    @FunctionalInterface
    private static interface BodyConsumer {
        public void getWailaBody(ItemStack var1, List<String> var2, IWailaDataAccessor var3, IWailaConfigHandler var4);
    }

    @FunctionalInterface
    private static interface TileBodyConsumer<T> {
        public void getWailaBody(ItemStack var1, List<String> var2, IWailaDataAccessor var3, IWailaConfigHandler var4, T var5);
    }
}

