/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.entity.villager.WerewolfVillager;
import org.cyclops.evilcraft.entity.villager.WerewolfVillagerConfig;
import org.cyclops.evilcraft.item.IItemEmpowerable;

public class EntityStruckByLightningEventHook {
    private EntityLightningBolt lastLightningBolt;
    private Set<EntityVillager> affectedVillagers;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        this.empowerItem(event);
        this.transformVillager(event);
    }

    private void empowerItem(EntityStruckByLightningEvent event) {
        IItemEmpowerable empowerable;
        EntityItem entity;
        if (event.getEntity() instanceof EntityItem && (entity = (EntityItem)event.getEntity()).func_92059_d().func_77973_b() instanceof IItemEmpowerable && !(empowerable = (IItemEmpowerable)entity.func_92059_d().func_77973_b()).isEmpowered(entity.func_92059_d())) {
            entity.func_92058_a(empowerable.empower(entity.func_92059_d()));
            event.setCanceled(true);
            event.getLightning().func_70106_y();
        }
    }

    private void transformVillager(EntityStruckByLightningEvent event) {
        if (Configs.isEnabled(WerewolfVillagerConfig.class) && event.getEntity() instanceof EntityVillager) {
            EntityVillager entity = (EntityVillager)event.getEntity();
            if (this.lastLightningBolt != event.getLightning()) {
                this.lastLightningBolt = event.getLightning();
                this.affectedVillagers = new HashSet<EntityVillager>();
            }
            if (!this.affectedVillagers.add(entity)) {
                event.setCanceled(true);
                return;
            }
            if (entity.getProfessionForge() != WerewolfVillager.getInstance()) {
                entity.setProfession((VillagerRegistry.VillagerProfession)WerewolfVillager.getInstance());
            }
            if (entity.func_190670_t_().field_73012_v.nextBoolean()) {
                event.setCanceled(true);
            }
        }
    }
}

