/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.tileentity;

import java.util.LinkedList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;

public abstract class TickingTankInventoryTileEntity<T extends TankInventoryTileEntity>
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    protected final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private LinkedList<TickComponent<T, ITickAction<T>>> tickers = new LinkedList();
    private int currentState = -1;
    private int previousState = -1;

    public TickingTankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, Fluid acceptedFluid, int StackSize) {
        super(inventorySize, inventoryName, StackSize, tankSize, tankName, acceptedFluid);
    }

    public TickingTankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, Fluid acceptedFluid) {
        this(inventorySize, inventoryName, tankSize, tankName, acceptedFluid, 64);
    }

    protected int addTicker(TickComponent<T, ITickAction<T>> ticker) {
        this.tickers.add(ticker);
        return this.tickers.size() - 1;
    }

    public LinkedList<TickComponent<T, ITickAction<T>>> getTickers() {
        return this.tickers;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.currentState = data.func_74762_e("currentState");
        NBTTagList tickerList = data.func_150295_c("tickers", 10);
        for (int i = 0; i < this.tickers.size(); ++i) {
            NBTTagCompound tag;
            TickComponent<T, ITickAction<T>> ticker = this.tickers.get(i);
            if (tickerList.func_74745_c() <= i || (tag = tickerList.func_150305_b(i)) == null) continue;
            ticker.setTick(tag.func_74762_e("tick"));
            ticker.setRequiredTicks(tag.func_74760_g("requiredTicks"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        data.func_74768_a("currentState", this.currentState);
        NBTTagList tickerList = new NBTTagList();
        for (TickComponent tickComponent : this.tickers) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("tick", tickComponent.getTick());
            tag.func_74776_a("requiredTicks", tickComponent.getRequiredTicks());
            tickerList.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("tickers", (NBTBase)tickerList);
        return data;
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        if (!this.field_145850_b.field_72995_K) {
            boolean redstone = this.field_145850_b.func_175640_z(this.func_174877_v());
            for (TickComponent tickComponent : this.getTickers()) {
                if (tickComponent.isRedstoneDisableable() && redstone) continue;
                tickComponent.tick(this.inventory.func_70301_a(tickComponent.getSlot()), tickComponent.getSlot());
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            int newState = this.getNewState();
            if (newState != this.currentState) {
                this.currentState = newState;
                this.onStateChanged();
            }
        } else if (this.previousState != this.currentState) {
            this.previousState = this.currentState;
            this.onStateChanged();
        }
    }

    public abstract int getNewState();

    public abstract void onStateChanged();

    public int getCurrentState() {
        return this.currentState;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

