/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.block.EntangledChalice;
import org.cyclops.evilcraft.block.EntangledChaliceConfig;
import org.cyclops.evilcraft.block.EntangledChaliceItem;

public class ModelEntangledChaliceBaked
extends DelegatingDynamicItemAndBlockModel {
    private static final Map<String, Integer> seeds = Maps.newHashMap();
    public static IBakedModel chaliceModel;
    public static IBakedModel gemsModel;
    private final String id;
    private final FluidStack fluidStack;

    public ModelEntangledChaliceBaked() {
        this.id = "";
        this.fluidStack = null;
    }

    public ModelEntangledChaliceBaked(String id, FluidStack fluidStack, IBlockState blockState, EnumFacing facing, long rand) {
        super(blockState, facing, rand);
        this.id = id != null ? id : "";
        this.fluidStack = fluidStack;
    }

    public ModelEntangledChaliceBaked(String id, FluidStack fluidStack, ItemStack itemStack, World world, EntityLivingBase entity) {
        super(itemStack, world, entity);
        this.id = id != null ? id : "";
        this.fluidStack = fluidStack;
    }

    public static int getColorSeed(String id) {
        int gemColor;
        if (seeds.containsKey(id)) {
            gemColor = seeds.get(id);
        } else {
            long res = id.hashCode();
            Random rand = new Random(res);
            gemColor = rand.nextInt(0x1000000) | 0xFF000000;
            seeds.put(id, gemColor);
        }
        return gemColor;
    }

    public List<BakedQuad> getGeneralQuads() {
        LinkedList quads = Lists.newLinkedList();
        quads.addAll(chaliceModel.func_188616_a(this.blockState, this.facing, this.rand));
        int color = ModelEntangledChaliceBaked.getColorSeed(this.id);
        for (BakedQuad quad : gemsModel.func_188616_a(this.blockState, this.facing, this.rand)) {
            int[] data = quad.func_178209_a();
            for (int i = 0; i < data.length / 7; ++i) {
                data[i * 7 + 3] = color;
            }
            quads.add(new BakedQuad(data, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), true, DefaultVertexFormats.field_176599_b));
        }
        if (this.fluidStack != null) {
            quads.addAll(this.getFluidQuads(this.fluidStack, 4000));
        }
        return quads;
    }

    public IBakedModel handleBlockState(IBlockState state, EnumFacing side, long rand) {
        String tankId = (String)((IExtendedBlockState)state).getValue(EntangledChalice.TANK_ID);
        FluidStack fluidStack = (FluidStack)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)((IExtendedBlockState)state), EntangledChalice.TANK_FLUID, null);
        if (!EntangledChaliceConfig.staticBlockRendering) {
            fluidStack = null;
        }
        return new ModelEntangledChaliceBaked(tankId, fluidStack, state, side, rand);
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, EntityLivingBase entity) {
        String id = !itemStack.func_190926_b() ? ((EntangledChaliceItem.FluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack)).getTankID() : "";
        return new ModelEntangledChaliceBaked(id, !itemStack.func_190926_b() ? FluidUtil.getFluidContained((ItemStack)itemStack) : null, itemStack, world, entity);
    }

    public TextureAtlasSprite func_177554_e() {
        return chaliceModel.func_177554_e();
    }

    protected List<BakedQuad> getFluidQuads(FluidStack fluidStack, int capacity) {
        float height = Math.min(0.95f, (float)fluidStack.amount / (float)capacity) * 0.1875f + 0.8125f;
        ArrayList quads = Lists.newArrayList();
        TextureAtlasSprite texture = RenderHelpers.getFluidIcon((FluidStack)fluidStack, (EnumFacing)EnumFacing.UP);
        ModelEntangledChaliceBaked.addBakedQuadRotated((List)quads, (float)0.1875f, (float)0.8125f, (float)0.1875f, (float)0.8125f, (float)height, (TextureAtlasSprite)texture, (EnumFacing)EnumFacing.UP, (int)ROTATION_FIX[EnumFacing.UP.ordinal()]);
        return quads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelEntangledChaliceBaked)) {
            return false;
        }
        ModelEntangledChaliceBaked other = (ModelEntangledChaliceBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        FluidStack this$fluidStack = this.getFluidStack();
        FluidStack other$fluidStack = other.getFluidStack();
        return !(this$fluidStack == null ? other$fluidStack != null : !this$fluidStack.equals(other$fluidStack));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelEntangledChaliceBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        FluidStack $fluidStack = this.getFluidStack();
        result = result * 59 + ($fluidStack == null ? 0 : $fluidStack.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public String toString() {
        return "ModelEntangledChaliceBaked(id=" + this.getId() + ", fluidStack=" + this.getFluidStack() + ")";
    }
}

