/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import erebus.ModBlocks;
import erebus.ModSounds;
import erebus.blocks.BlockTempleBrickUnbreaking;
import erebus.blocks.BlockTempleTeleporter;
import erebus.core.helper.Utils;
import erebus.world.feature.structure.WorldGenAntlionDungeon;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityTempleTeleporter
extends TileEntity
implements ITickable {
    private int targetX;
    private int targetY;
    private int targetZ;
    private boolean bossSpawn = true;
    private boolean playOpenSound = true;

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (((BlockTempleTeleporter.EnumTeleporterType)((Object)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(BlockTempleTeleporter.TYPE))).ordinal() < 4) {
            int activeCount = 0;
            int activeCountLast = 0;
            for (int offX = -1; offX < 2; ++offX) {
                for (int offZ = -1; offZ < 2; ++offZ) {
                    if (this.func_174877_v().func_177982_a(offX, 0, offZ) == this.func_174877_v() || !(this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(offX, 0, offZ)).func_177230_c() instanceof BlockTempleBrickUnbreaking)) continue;
                    if (((BlockTempleBrickUnbreaking.EnumTempleBrickType)((Object)this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(offX, 0, offZ)).func_177229_b(BlockTempleBrickUnbreaking.TYPE))).ordinal() >= 6 && ((BlockTempleBrickUnbreaking.EnumTempleBrickType)((Object)this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(offX, 0, offZ)).func_177229_b(BlockTempleBrickUnbreaking.TYPE))).ordinal() <= 9) {
                        ++activeCount;
                        continue;
                    }
                    if (((BlockTempleBrickUnbreaking.EnumTempleBrickType)((Object)this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(offX, 0, offZ)).func_177229_b(BlockTempleBrickUnbreaking.TYPE))).ordinal() != 10) continue;
                    ++activeCountLast;
                }
            }
            if (activeCount == 8) {
                this.setAnimationMeta();
            }
            if (activeCountLast == 8) {
                this.setDestoyForcefield();
            }
        }
        if (this.func_145831_w().func_82737_E() % 5L == 0L && this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() != null && this.isActiveTeleporter()) {
            this.activateBlock();
        }
    }

    public boolean isActiveTeleporter() {
        int type = ((BlockTempleTeleporter.EnumTeleporterType)((Object)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(BlockTempleTeleporter.TYPE))).ordinal();
        return type >= 4 && type <= 9;
    }

    protected Entity activateBlock() {
        List list = this.func_145831_w().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.func_174877_v().func_177984_a()).func_72314_b(0.0, 0.25, 0.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityLivingBase)) continue;
            if (entity.func_70093_af()) {
                return null;
            }
            ((EntityLivingBase)entity).func_70634_a((double)this.getTargetX() + 0.5, (double)this.getTargetY() + 1.0, (double)this.getTargetZ() + 0.5);
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return null;
    }

    private void setDestoyForcefield() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        BlockTempleTeleporter.EnumTeleporterType type = (BlockTempleTeleporter.EnumTeleporterType)((Object)state.func_177229_b(BlockTempleTeleporter.TYPE));
        int meta = type.ordinal();
        if (meta == 0 && this.playOpenSound) {
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), ModSounds.ALTAR_CHANGE_STATE, SoundCategory.BLOCKS, 1.0f, 1.3f);
            this.playOpenSound = false;
        }
        if (this.func_145831_w().func_72820_D() % 5L == 0L && meta < 4) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), ModBlocks.TEMPLE_TELEPORTER.func_176223_P().func_177226_a(BlockTempleTeleporter.TYPE, (Comparable)((Object)BlockTempleTeleporter.EnumTeleporterType.values()[meta + 1])), 3);
        }
        if (meta == 3 && this.bossSpawn) {
            WorldGenAntlionDungeon.breakForceField(this.func_145831_w(), this.func_174877_v().func_177958_n() - 16, this.func_174877_v().func_177956_o() + 1, this.func_174877_v().func_177952_p() - 27);
            ItemStack nightVisionPotion = new ItemStack((Item)Items.field_151068_bn, 1, 0);
            PotionUtils.func_185188_a((ItemStack)nightVisionPotion, (PotionType)PotionTypes.field_185234_f);
            ItemStack fireResitancePotion = new ItemStack((Item)Items.field_151068_bn, 1, 0);
            PotionUtils.func_185188_a((ItemStack)fireResitancePotion, (PotionType)PotionTypes.field_185241_m);
            Utils.dropStackNoRandom(this.func_145831_w(), this.func_174877_v().func_177981_b(2), nightVisionPotion);
            Utils.dropStackNoRandom(this.func_145831_w(), this.func_174877_v().func_177981_b(2), fireResitancePotion);
            this.bossSpawn = false;
        }
    }

    public void setAnimationMeta() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        BlockTempleTeleporter.EnumTeleporterType type = (BlockTempleTeleporter.EnumTeleporterType)((Object)state.func_177229_b(BlockTempleTeleporter.TYPE));
        int meta = type.ordinal();
        if (meta == 0 && this.playOpenSound) {
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), ModSounds.ALTAR_CHANGE_STATE, SoundCategory.BLOCKS, 1.0f, 1.3f);
            this.playOpenSound = false;
        }
        if (this.func_145831_w().func_72820_D() % 5L == 0L && meta < 4) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), ModBlocks.TEMPLE_TELEPORTER.func_176223_P().func_177226_a(BlockTempleTeleporter.TYPE, (Comparable)((Object)BlockTempleTeleporter.EnumTeleporterType.values()[meta + 1])), 3);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void markForUpdate() {
        if (this != null && !this.func_145831_w().field_72995_K) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 8);
            this.func_70296_d();
        }
    }

    public void setTargetDestination(BlockPos pos) {
        this.setTargetDestination(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void setTargetDestination(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public int getTargetX() {
        return this.targetX;
    }

    public int getTargetY() {
        return this.targetY;
    }

    public int getTargetZ() {
        return this.targetZ;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setTargetDestination(nbt.func_74762_e("targetX"), nbt.func_74762_e("targetY"), nbt.func_74762_e("targetZ"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("targetX", this.getTargetX());
        nbt.func_74768_a("targetY", this.getTargetY());
        nbt.func_74768_a("targetZ", this.getTargetZ());
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
        this.markForUpdate();
    }
}

