/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModItems;
import erebus.ModTabs;
import erebus.core.helper.Utils;
import erebus.items.ItemErebusFood;
import erebus.items.ItemMaterials;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBerryBush
extends Block {
    private String type;
    public static final PropertyInteger BUSH_AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    private static final AxisAlignedBB[] BUSH_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockBerryBush(String bushType) {
        super(Material.field_151584_j);
        this.type = bushType;
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149647_a(ModTabs.PLANTS);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public int func_149738_a(World world) {
        return 10;
    }

    protected PropertyInteger getAgeProperty() {
        return BUSH_AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BUSH_AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BUSH_AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BUSH_AGE);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BUSH_AABB[(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return BUSH_AABB[(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int age = this.getAge(state);
        if (rand.nextInt(25) == 0) {
            switch (age) {
                case 0: {
                    world.func_180501_a(pos, this.withAge(1), 2);
                    break;
                }
                case 1: {
                    world.func_180501_a(pos, this.withAge(2), 2);
                }
            }
        }
        if (age == 2 && rand.nextInt(50) == 0) {
            world.func_180501_a(pos, this.withAge(3), 2);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int age = this.getAge(state);
        if (age == 3) {
            world.func_184133_a(player, pos, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, 2.0f);
            if (!player.field_71071_by.func_70441_a(this.getBerry())) {
                Utils.dropStack(world, pos, this.getBerry());
            }
            world.func_180501_a(pos, this.withAge(2), 2);
            return true;
        }
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int age = this.getAge(state);
        if (age == 3) {
            Utils.dropStack(world, pos, this.getBerry());
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        return this.isValidBlock(state);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return this.func_176196_c(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int age = this.getAge(state);
        if (world.func_175623_d(pos.func_177977_b())) {
            if (age == 3) {
                Utils.dropStack(world, pos, this.getBerry());
            }
            Utils.dropStack(world, pos, new ItemStack(Item.func_150898_a((Block)this)));
            world.func_175698_g(pos);
        }
        this.canBlockStay(world, pos);
    }

    private boolean isValidBlock(IBlockState state) {
        Block block = state.func_177230_c();
        return block != null && (block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == Blocks.field_150349_c || block == this && this.getAge(state) >= 2);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 1;
    }

    public ItemStack getBerry() {
        ItemStack item = ItemStack.field_190927_a;
        if (this.type == "JADE") {
            item = new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.JADE_BERRIES.ordinal());
        }
        if (this.type == "HEART") {
            item = new ItemStack(ModItems.HEART_BERRIES, 1);
        }
        if (this.type == "SWAMP") {
            item = new ItemStack(ModItems.EREBUS_FOOD, 1, ItemErebusFood.EnumFoodType.SWAMP_BERRIES.ordinal());
        }
        return item;
    }
}

