/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.capabilities;

import net.foxmcloud.draconicadditions.capabilities.IChaosInBlood;

public class ChaosInBlood
implements IChaosInBlood {
    private float chaosInBlood = 0.0f;
    private float chaosInBloodLast = 0.0f;
    private final float maxChaosInBlood = 20.0f;

    @Override
    public float getChaos() {
        return this.chaosInBlood;
    }

    @Override
    public float getLastChaos() {
        return this.chaosInBloodLast;
    }

    @Override
    public boolean hasChaos() {
        return this.chaosInBlood > 0.0f;
    }

    @Override
    public boolean hadChaosLastUpdate() {
        boolean hadChaos = this.chaosInBloodLast > 0.0f;
        this.chaosInBloodLast = this.chaosInBlood;
        return hadChaos;
    }

    @Override
    public float addChaos(float chaos) {
        this.chaosInBloodLast = this.chaosInBlood;
        float chaosToAdd = Math.min(20.0f - this.chaosInBlood, chaos);
        this.chaosInBlood += chaosToAdd;
        return chaos - chaosToAdd;
    }

    @Override
    public float removeChaos(float chaos) {
        this.chaosInBloodLast = this.chaosInBlood;
        float chaosToRemove = Math.min(this.chaosInBlood, chaos);
        this.chaosInBlood -= chaosToRemove;
        return chaosToRemove;
    }

    @Override
    public void setChaos(float chaos) {
        float chaosToSet;
        this.chaosInBloodLast = this.chaosInBlood;
        this.chaosInBlood = chaosToSet = Math.min(20.0f, chaos);
    }
}

