/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world;

import divinerpg.registry.BlockRegistry;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class DivineTree
extends WorldGenAbstractTree {
    private final int minTreeHeight;

    public DivineTree(boolean notify) {
        this(notify, 5);
    }

    public DivineTree(boolean notify, int minTreeHeightIn) {
        super(notify);
        this.minTreeHeight = minTreeHeightIn;
    }

    @ParametersAreNonnullByDefault
    public boolean func_180709_b(World worldIn, Random rand, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int treeHeight = rand.nextInt(3) + this.minTreeHeight;
        boolean canGenerate = true;
        int treeTopPos = blockPos.func_177956_o() + treeHeight;
        if (blockPos.func_177956_o() >= 1 && treeTopPos <= 255) {
            for (int iPosY = blockPos.func_177956_o(); iPosY <= treeTopPos + 1; ++iPosY) {
                int k = 1;
                if (iPosY == blockPos.func_177956_o()) {
                    k = 0;
                }
                if (iPosY >= treeTopPos - 1) {
                    k = 2;
                }
                int halflength = blockPos.func_177958_n() + k;
                for (int iPosX = blockPos.func_177958_n() - k; iPosX <= halflength + k && canGenerate; ++iPosX) {
                    int halfLength = blockPos.func_177952_p() + k;
                    for (int iPosZ = blockPos.func_177952_p() - k; iPosZ <= halfLength + k && canGenerate; ++iPosZ) {
                        if (iPosY >= 0 && iPosY < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)mutableBlockPos.func_181079_c(iPosX, iPosY, iPosZ))) continue;
                            canGenerate = false;
                            continue;
                        }
                        canGenerate = false;
                    }
                }
            }
            if (!canGenerate) {
                return false;
            }
            IBlockState logState = BlockRegistry.divineLog.func_176223_P();
            IBlockState leavesState = BlockRegistry.divineLeaves.func_176223_P();
            BlockPos down = blockPos.func_177977_b();
            IBlockState blockState = worldIn.func_180495_p(down);
            Block block = blockState.func_177230_c();
            boolean isSoil = block.canSustainPlant(blockState, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && treeTopPos + 1 < 256) {
                block.onPlantGrow(blockState, worldIn, down, blockPos);
                for (int iPosY = treeTopPos - 3; iPosY <= treeTopPos; ++iPosY) {
                    int distanceToTop = iPosY - treeTopPos;
                    int margin = 1 - distanceToTop / 2;
                    int xEnd = blockPos.func_177958_n() + margin;
                    for (int xStart = blockPos.func_177958_n() - margin; xStart <= xEnd; ++xStart) {
                        int currentMarginX = Math.abs(xStart - blockPos.func_177958_n());
                        int zEnd = blockPos.func_177952_p() + margin;
                        for (int zStart = blockPos.func_177952_p() - margin; zStart <= zEnd; ++zStart) {
                            int currentMarginZ = Math.abs(zStart - blockPos.func_177952_p());
                            if (currentMarginX == margin && currentMarginZ == margin && (rand.nextInt(2) == 0 || distanceToTop == 0)) continue;
                            BlockPos leavesBlockPos = new BlockPos(xStart, iPosY, zStart);
                            IBlockState leavesBlockState = worldIn.func_180495_p(leavesBlockPos);
                            Block leavesBlock = worldIn.func_180495_p(leavesBlockPos).func_177230_c();
                            if (!leavesBlock.isAir(leavesBlockState, (IBlockAccess)worldIn, leavesBlockPos) && !leavesBlock.isLeaves(leavesBlockState, (IBlockAccess)worldIn, leavesBlockPos) && leavesBlockState.func_185904_a() != Material.field_151582_l) continue;
                            this.func_175903_a(worldIn, leavesBlockPos, leavesState);
                        }
                    }
                }
                for (int i = 0; i < treeHeight; ++i) {
                    BlockPos upN = blockPos.func_177981_b(i);
                    IBlockState blockStateUp = worldIn.func_180495_p(upN);
                    Block blockUp = blockStateUp.func_177230_c();
                    if (!blockUp.isAir(blockStateUp, (IBlockAccess)worldIn, upN) && !blockUp.isLeaves(blockStateUp, (IBlockAccess)worldIn, upN) && blockStateUp.func_185904_a() != Material.field_151582_l) continue;
                    this.func_175903_a(worldIn, blockPos.func_177981_b(i), logState);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

