/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks.twilight;

import divinerpg.registry.DivineRPGTabs;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

public class BlockModDoublePlant
extends BlockBush
implements IPlantable,
IShearable {
    public static final PropertyEnum<EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumBlockHalf.class);
    protected static final AxisAlignedBB DOUBLE_PLANT_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);
    private Supplier<Block> grassSupplier;

    public BlockModDoublePlant(String name, Supplier<Block> grassSupplier, MapColor mapColorIn) {
        super(Material.field_151585_k, mapColorIn);
        this.setRegistryName("divinerpg", name);
        this.func_149663_c(name);
        this.grassSupplier = grassSupplier;
        this.func_149647_a(DivineRPGTabs.BLOCKS);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.LOWER)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DOUBLE_PLANT_AABB;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c() == this.grassSupplier.get() && worldIn.func_175623_d(pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            this.func_180663_b(worldIn, pos, state);
            BlockModDoublePlant.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)this)));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        if (state.func_177229_b(HALF) == EnumBlockHalf.UPPER) {
            worldIn.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.func_180671_f(worldIn, pos, state);
        }
        if (state.func_177229_b(HALF) == EnumBlockHalf.UPPER) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
        return iblockstate.func_177230_c() == this && super.func_180671_f(worldIn, pos, iblockstate);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(HALF) == EnumBlockHalf.LOWER) {
            worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.UPPER)), 3);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > 0) {
            return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.UPPER));
        }
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.LOWER));
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public NonNullList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1));
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(HALF) == EnumBlockHalf.UPPER ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public Block getGrass() {
        return this.grassSupplier.get();
    }

    public static enum EnumBlockHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

