/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks.tile.entity;

import divinerpg.DivineRPG;
import divinerpg.registry.ItemRegistry;
import divinerpg.utils.LocalizeUtils;
import divinerpg.utils.PositionHelper;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class TileEntitySingleUseSpawner
extends TileEntity
implements ITickable {
    private ResourceLocation entityId;
    private int defaultDelay;
    private int delay;
    private int blockReachDistance;
    private boolean isActivated = false;
    private BlockPos searchRadius = new BlockPos(8, 4, 8);
    private BlockPos baseOffset;

    public TileEntitySingleUseSpawner() {
    }

    public TileEntitySingleUseSpawner(Class<? extends Entity> entityClass, int delay, int blockReachDistance, BlockPos baseOffset) {
        this.entityId = EntityList.func_191306_a(entityClass);
        this.defaultDelay = delay;
        this.delay = 0;
        this.blockReachDistance = blockReachDistance;
        this.baseOffset = baseOffset;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound result = super.func_189515_b(compound);
        result.func_74768_a("delay", this.delay);
        result.func_74772_a("addY", this.baseOffset.func_177986_g());
        result.func_74757_a("activated", this.isActivated);
        result.func_74768_a("spawnNearPlayer", this.blockReachDistance);
        result.func_74778_a("entityID", this.entityId.toString());
        return result;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.delay = compound.func_74762_e("delay");
        this.baseOffset = BlockPos.func_177969_a((long)compound.func_74763_f("addY"));
        this.isActivated = compound.func_74767_n("activated");
        this.blockReachDistance = compound.func_74762_e("spawnNearPlayer");
        this.entityId = new ResourceLocation(compound.func_74779_i("entityID"));
    }

    public void func_73660_a() {
        if (!this.isActivated) {
            return;
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return;
        }
        if (this.entityId == null) {
            String blockName = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().getRegistryName().toString();
            DivineRPG.logger.warn("Spawner block " + blockName + " can't summon entity, entityId is null");
            return;
        }
        Entity entity = EntityList.func_188429_b((ResourceLocation)this.entityId, (World)this.field_145850_b);
        if (entity == null) {
            String blockName = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().getRegistryName().toString();
            DivineRPG.logger.warn("Spawner block " + blockName + " can't summon entity, entity is null");
            return;
        }
        if ((entity = this.getRelocatedEntity(entity)) != null) {
            this.field_145850_b.func_72838_d(entity);
        } else {
            DivineRPG.logger.warn("Can't summon entity, there is no free place here");
        }
        this.deactivate();
    }

    public void activate(EntityPlayer player) {
        if (this.isActivated) {
            return;
        }
        this.isActivated = true;
        this.delay = this.defaultDelay;
        if (!this.field_145850_b.field_72995_K && this.delay > 0) {
            if (player.func_184614_ca().func_77973_b() == ItemRegistry.edenChunk) {
                player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, LocalizeUtils.i18n(TextFormatting.YELLOW, String.format("entity.%s.name", EntityList.func_191302_a((ResourceLocation)this.entityId)), new Object[0]), new Object[0]));
            } else if (player.func_184614_ca().func_77973_b() == ItemRegistry.wildwoodChunk) {
                player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, LocalizeUtils.i18n(TextFormatting.DARK_BLUE, String.format("entity.%s.name", EntityList.func_191302_a((ResourceLocation)this.entityId)), new Object[0]), new Object[0]));
            } else if (player.func_184614_ca().func_77973_b() == ItemRegistry.apalachiaChunk) {
                player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, LocalizeUtils.i18n(TextFormatting.DARK_GREEN, String.format("entity.%s.name", EntityList.func_191302_a((ResourceLocation)this.entityId)), new Object[0]), new Object[0]));
            } else if (player.func_184614_ca().func_77973_b() == ItemRegistry.skythernChunk) {
                player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, LocalizeUtils.i18n(TextFormatting.AQUA, String.format("entity.%s.name", EntityList.func_191302_a((ResourceLocation)this.entityId)), new Object[0]), new Object[0]));
            }
            player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "summon.single_use_spawner.delay", this.delay / 20));
        }
    }

    private void deactivate() {
        this.isActivated = false;
    }

    protected Entity getRelocatedEntity(Entity e) {
        BlockPos intialSpawnPosition = this.field_174879_c.func_177981_b(this.searchRadius.func_177956_o() / 2).func_177971_a((Vec3i)this.baseOffset);
        BlockPos blockPos = PositionHelper.searchInRadius(this.field_145850_b, intialSpawnPosition, this.searchRadius, x -> {
            e.func_70107_b((double)x.func_177958_n(), (double)x.func_177956_o(), (double)x.func_177952_p());
            return this.field_145850_b.func_184144_a(e, e.func_174813_aQ()).isEmpty();
        });
        if (blockPos == null) {
            return null;
        }
        e.func_70107_b((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        return e;
    }

    public boolean isActivated() {
        return this.isActivated;
    }
}

