/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.api.DivineAPI;
import divinerpg.api.arcana.IArcana;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ArcanaTickHandler {
    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            DivineAPI.getArcana((Entity)event.player).regen(event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.refillArcana(event.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.refillArcana(event.player);
        event.player.func_82242_a(0);
    }

    private void refillArcana(EntityPlayer player) {
        IArcana arcana = DivineAPI.getArcana((Entity)player);
        if (arcana == null) {
            return;
        }
        arcana.fill(player, arcana.getMaxArcana());
    }
}

