/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.arcana.mazegen;

import net.minecraft.util.Rotation;

public class Cell {
    public int x;
    public int y;
    public int identifier;
    public boolean hasNorthEdge;
    public boolean hasEastEdge;
    public boolean hasSouthEdge;
    public boolean hasWestEdge;

    public Cell(int x, int y) {
        this.x = x;
        this.y = y;
        this.identifier = x * 64 + y;
        this.hasNorthEdge = true;
        this.hasEastEdge = true;
        this.hasSouthEdge = true;
        this.hasWestEdge = true;
    }

    public int getNumberOfEdges() {
        int result = 0;
        if (this.hasNorthEdge) {
            ++result;
        }
        if (this.hasEastEdge) {
            ++result;
        }
        if (this.hasSouthEdge) {
            ++result;
        }
        if (this.hasWestEdge) {
            ++result;
        }
        return result;
    }

    public PieceType getPieceType() {
        switch (this.getNumberOfEdges()) {
            case 0: {
                return PieceType.CROSSROADS;
            }
            case 1: {
                return PieceType.JUNCTION;
            }
            case 2: {
                if (this.hasNorthEdge && this.hasSouthEdge || this.hasEastEdge && this.hasWestEdge) {
                    return PieceType.HALLWAY;
                }
                return PieceType.CORNER;
            }
            case 3: {
                return PieceType.DEAD_END;
            }
        }
        return null;
    }

    public Rotation getRotation() {
        switch (this.getPieceType()) {
            case CROSSROADS: {
                return Rotation.NONE;
            }
            case JUNCTION: {
                if (this.hasNorthEdge) {
                    return Rotation.NONE;
                }
                if (this.hasEastEdge) {
                    return Rotation.CLOCKWISE_90;
                }
                if (this.hasSouthEdge) {
                    return Rotation.CLOCKWISE_180;
                }
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case CORNER: {
                if (!this.hasSouthEdge) {
                    if (!this.hasWestEdge) {
                        return Rotation.NONE;
                    }
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                if (!this.hasEastEdge) {
                    return Rotation.CLOCKWISE_180;
                }
                return Rotation.CLOCKWISE_90;
            }
            case HALLWAY: {
                if (!this.hasSouthEdge) {
                    return Rotation.NONE;
                }
                return Rotation.CLOCKWISE_90;
            }
            case DEAD_END: {
                if (!this.hasSouthEdge) {
                    return Rotation.NONE;
                }
                if (!this.hasWestEdge) {
                    return Rotation.CLOCKWISE_90;
                }
                if (!this.hasNorthEdge) {
                    return Rotation.CLOCKWISE_180;
                }
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return null;
    }

    public static enum PieceType {
        CROSSROADS,
        JUNCTION,
        HALLWAY,
        CORNER,
        DEAD_END;

    }
}

