/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.baubles;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BaublesCompat {
    public static void changeBaubles(EntityPlayer player, NBTTagCompound tag, boolean backToOverworld) {
        List<String> tagNames = Arrays.asList("Baubles_Overworld", "Baubles_Vethea");
        if (backToOverworld) {
            Collections.reverse(tagNames);
        }
        String saveTo = tagNames.get(0);
        String loadFrom = tagNames.get(1);
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        tag.func_74782_a(saveTo, (NBTBase)BaublesCompat.serializeBaubles(handler));
        BaublesCompat.deserializeBaubles(handler, (NBTTagList)tag.func_74781_a(loadFrom));
    }

    private static NBTTagList serializeBaubles(IBaublesItemHandler baublesHandler) {
        NBTTagList serializedInventory = new NBTTagList();
        for (int slotIndex = 0; slotIndex < baublesHandler.getSlots(); ++slotIndex) {
            NBTTagCompound serializedSlot = baublesHandler.getStackInSlot(slotIndex).func_77955_b(new NBTTagCompound());
            serializedInventory.func_74742_a((NBTBase)serializedSlot);
        }
        return serializedInventory;
    }

    private static void deserializeBaubles(IBaublesItemHandler baublesHandler, NBTTagList serializedInventory) {
        for (int slotIndex = 0; slotIndex < baublesHandler.getSlots(); ++slotIndex) {
            if (serializedInventory == null) {
                baublesHandler.setStackInSlot(slotIndex, ItemStack.field_190927_a);
                continue;
            }
            NBTBase slotNbt = serializedInventory.func_179238_g(slotIndex);
            if (slotNbt instanceof NBTTagCompound) {
                ItemStack deserializedItem = new ItemStack((NBTTagCompound)serializedInventory.func_179238_g(slotIndex));
                baublesHandler.setStackInSlot(slotIndex, deserializedItem);
                continue;
            }
            baublesHandler.setStackInSlot(slotIndex, ItemStack.field_190927_a);
        }
    }
}

