/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public abstract class PlayerPositionPacket
extends PacketCodec {
    private static final int DEFAULT_RANGE = 3000;
    @CodecField
    protected String displayName;
    @CodecField
    protected Vec3d position = new Vec3d(0.0, 0.0, 0.0);
    @CodecField
    private int range = 3000;

    public PlayerPositionPacket() {
    }

    public PlayerPositionPacket(EntityPlayer player) {
        this(player, 3000);
    }

    public PlayerPositionPacket(EntityPlayer player, int range) {
        this.displayName = player.getDisplayNameString();
        this.position = player.func_174791_d();
        this.range = range;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        if (this.displayName == null) {
            this.getModInstance().log(Level.WARN, "Got PlayerPositionPacket with empty displayName");
            return;
        }
        if (player != null && !player.getDisplayNameString().equals(this.displayName)) {
            player = world.func_72924_a(this.displayName);
        }
        if (player == null) {
            this.getModInstance().log(Level.WARN, "Received PlayerPositionPacket for player with displayName '" + this.displayName + "', but player doesn't exist");
        } else {
            this.performClientAction(world, player);
        }
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
        this.getModInstance().getPacketHandler().sendToAllAround(this.create((EntityPlayer)player, this.range), LocationHelpers.createTargetPointFromEntity((Entity)player, this.range));
    }

    protected abstract PlayerPositionPacket create(EntityPlayer var1, int var2);

    protected abstract ModBase getModInstance();

    protected abstract void performClientAction(World var1, EntityPlayer var2);
}

