/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurable;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.BlockPropertyManagerComponent;
import org.cyclops.cyclopscore.block.property.IBlockPropertyManager;
import org.cyclops.cyclopscore.config.configurable.IConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.world.gen.WorldGeneratorTree;

public class ConfigurableBlockSapling
extends BlockSapling
implements IConfigurableBlock {
    private IBlockPropertyManager propertyManager;
    @BlockProperty
    public static final IProperty[] _COMPAT = new IProperty[]{field_176479_b};
    @BlockProperty(ignore=true)
    public static final IProperty[] _COMPAT_IGNORED = new IProperty[]{field_176480_a};
    protected BlockConfig eConfig = null;
    protected boolean hasGui = false;
    private WorldGeneratorTree treeGenerator;

    protected BlockStateContainer func_180661_e() {
        this.propertyManager = new BlockPropertyManagerComponent((Block)this);
        return this.propertyManager.createDelegatedBlockState();
    }

    public ConfigurableBlockSapling(ExtendedConfig<BlockConfig> eConfig, Material material, WorldGeneratorTree treeGenerator) {
        this.setConfig((BlockConfig)eConfig);
        this.func_149663_c(eConfig.getTranslationKey());
        this.treeGenerator = treeGenerator;
        this.func_149672_a(SoundType.field_185849_b);
    }

    @Override
    public boolean hasGui() {
        return this.hasGui;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColorHandler() {
        return null;
    }

    private void setConfig(BlockConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public BlockConfig getConfig() {
        return this.eConfig;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (!BlockHelpers.isValidCreativeTab((Block)this, creativeTabs)) {
            return;
        }
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }

    public void func_176476_e(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        world.func_175698_g(pos);
        if (!this.treeGenerator.growTree(world, rand, pos)) {
            world.func_180501_a(pos, state, 4);
        }
    }

    public int func_176201_c(IBlockState state) {
        return this.propertyManager.getMetaFromState(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.propertyManager.getStateFromMeta(meta);
    }

    public BlockStateContainer createDelegatedBlockState() {
        return this.propertyManager.createDelegatedBlockState();
    }
}

