/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import customskinloader.CustomSkinLoader;
import customskinloader.fake.texture.FakeBufferedImage;
import customskinloader.fake.texture.FakeImage;
import customskinloader.fake.texture.FakeNativeImage;
import java.awt.image.BufferedImage;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.NativeImage;

public class FakeSkinBuffer
implements IImageBuffer {
    private int ratio = 1;
    FakeImage image = null;
    static final Function<Integer, Predicate<Integer>> EQU_BG = bgColor -> FakeSkinBuffer.getA(bgColor) == 0 ? c -> FakeSkinBuffer.getA(c) == 0 : c -> c.equals(bgColor);
    private static final int A = 0xFFFFFF;
    private static final int WHITE = FakeSkinBuffer.getARGB(255, 255, 255, 255);
    private static final int BLACK = FakeSkinBuffer.getARGB(255, 0, 0, 0);
    private static final int B = -16777216;

    public static NativeImage processLegacySkin(NativeImage image, Runnable processTask, Function<NativeImage, NativeImage> processLegacySkin) {
        if (processTask instanceof IImageBuffer) {
            return ((IImageBuffer)processTask).func_195786_a(image);
        }
        return processLegacySkin.apply(image);
    }

    @Override
    public NativeImage func_195786_a(NativeImage image) {
        if (image == null) {
            return null;
        }
        FakeImage img = this.parseUserSkin(new FakeNativeImage(image));
        if (img instanceof FakeNativeImage) {
            return ((FakeNativeImage)img).getImage();
        }
        CustomSkinLoader.logger.warning("Failed to parseUserSkin(func_195786_a).");
        return null;
    }

    @Override
    public BufferedImage func_78432_a(BufferedImage image) {
        if (image == null) {
            return null;
        }
        FakeImage img = this.parseUserSkin(new FakeBufferedImage(image));
        if (img instanceof FakeBufferedImage) {
            return ((FakeBufferedImage)img).getImage();
        }
        CustomSkinLoader.logger.warning("Failed to parseUserSkin.");
        return null;
    }

    public FakeImage parseUserSkin(FakeImage image) {
        if (image == null) {
            return null;
        }
        this.ratio = image.getWidth() / 64;
        if (image.getHeight() != image.getWidth()) {
            FakeImage img = image.createImage(64 * this.ratio, 64 * this.ratio);
            img.copyImageData(image);
            image.close();
            image = img;
            image.fillArea(0 * this.ratio, 32 * this.ratio, 64 * this.ratio, 32 * this.ratio);
            image.copyArea(4 * this.ratio, 16 * this.ratio, 16 * this.ratio, 32 * this.ratio, 4 * this.ratio, 4 * this.ratio, true, false);
            image.copyArea(8 * this.ratio, 16 * this.ratio, 16 * this.ratio, 32 * this.ratio, 4 * this.ratio, 4 * this.ratio, true, false);
            image.copyArea(0 * this.ratio, 20 * this.ratio, 24 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(4 * this.ratio, 20 * this.ratio, 16 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(8 * this.ratio, 20 * this.ratio, 8 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(12 * this.ratio, 20 * this.ratio, 16 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(44 * this.ratio, 16 * this.ratio, -8 * this.ratio, 32 * this.ratio, 4 * this.ratio, 4 * this.ratio, true, false);
            image.copyArea(48 * this.ratio, 16 * this.ratio, -8 * this.ratio, 32 * this.ratio, 4 * this.ratio, 4 * this.ratio, true, false);
            image.copyArea(40 * this.ratio, 20 * this.ratio, 0 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(44 * this.ratio, 20 * this.ratio, -8 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(48 * this.ratio, 20 * this.ratio, -16 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(52 * this.ratio, 20 * this.ratio, -8 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
        }
        this.image = image;
        this.setAreaDueToConfig(0 * this.ratio, 0 * this.ratio, 32 * this.ratio, 16 * this.ratio);
        this.setAreaTransparent(32 * this.ratio, 0 * this.ratio, 64 * this.ratio, 16 * this.ratio);
        this.setAreaDueToConfig(16 * this.ratio, 16 * this.ratio, 40 * this.ratio, 32 * this.ratio);
        this.setAreaTransparent(16 * this.ratio, 32 * this.ratio, 40 * this.ratio, 48 * this.ratio);
        this.setAreaDueToConfig(40 * this.ratio, 16 * this.ratio, 56 * this.ratio, 32 * this.ratio);
        this.setAreaTransparent(40 * this.ratio, 32 * this.ratio, 56 * this.ratio, 48 * this.ratio);
        this.setAreaDueToConfig(0 * this.ratio, 16 * this.ratio, 16 * this.ratio, 32 * this.ratio);
        this.setAreaTransparent(0 * this.ratio, 32 * this.ratio, 16 * this.ratio, 48 * this.ratio);
        this.setAreaDueToConfig(32 * this.ratio, 48 * this.ratio, 48 * this.ratio, 64 * this.ratio);
        this.setAreaTransparent(48 * this.ratio, 48 * this.ratio, 64 * this.ratio, 64 * this.ratio);
        this.setAreaDueToConfig(16 * this.ratio, 48 * this.ratio, 32 * this.ratio, 64 * this.ratio);
        this.setAreaTransparent(0 * this.ratio, 48 * this.ratio, 16 * this.ratio, 64 * this.ratio);
        return image;
    }

    public String judgeType() {
        if (this.image == null) {
            return "default";
        }
        int bgColor = this.image.getRGBA(63 * this.ratio, 20 * this.ratio);
        Predicate<Integer> predicate = EQU_BG.apply(bgColor);
        for (int x = 54 * this.ratio; x <= 55 * this.ratio; ++x) {
            for (int y = 20 * this.ratio; y <= 31 * this.ratio; ++y) {
                int color = this.image.getRGBA(x, y);
                if (predicate.test(color)) continue;
                return "default";
            }
        }
        return "slim";
    }

    private boolean isFilled(int x0, int y0, int x1, int y1) {
        int data = this.image.getRGBA(x0, y0);
        if (data != WHITE && data != BLACK) {
            return false;
        }
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                if (this.image.getRGBA(x, y) == data) continue;
                return false;
            }
        }
        return true;
    }

    private void setAreaTransparent(int x0, int y0, int x1, int y1) {
        if (!this.isFilled(x0, y0, x1, y1)) {
            return;
        }
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                this.image.setRGBA(x, y, this.image.getRGBA(x, y) & 0xFFFFFF);
            }
        }
    }

    private void setAreaOpaque(int x0, int y0, int x1, int y1) {
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                this.image.setRGBA(x, y, this.image.getRGBA(x, y) | 0xFF000000);
            }
        }
    }

    private void setAreaDueToConfig(int x0, int y0, int x1, int y1) {
        if (CustomSkinLoader.config.enableTransparentSkin) {
            this.setAreaTransparent(x0, y0, x1, y1);
        } else {
            this.setAreaOpaque(x0, y0, x1, y1);
        }
    }

    @Override
    public void func_152634_a() {
    }

    private static int getARGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int getA(int argb) {
        return (argb & 0xFF000000) >>> 24;
    }
}

