/*
 * Decompiled with CFR 0.152.
 */
package customskinloader;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public boolean enableLogStdOut = false;
    private BufferedWriter writer = null;

    public Logger() {
    }

    public Logger(String logFile) {
        this(new File(logFile));
    }

    public Logger(File logFile) {
        try {
            if (!logFile.getParentFile().exists()) {
                logFile.getParentFile().mkdirs();
            }
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(logFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            System.out.println("Log Path: " + logFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean canPrintToStdOut(Level level) {
        return level.display() && this.enableLogStdOut;
    }

    public void log(Level level, String msg) {
        if (!this.canPrintToStdOut(level) && this.writer == null) {
            return;
        }
        String sb = String.format("[%s] [%s/%s] [CustomSkinLoader]: %s", DATE_FORMAT.format(new Date()), Thread.currentThread().getName(), level.getName(), msg);
        if (this.canPrintToStdOut(level)) {
            System.out.println(sb);
        }
        if (this.writer == null) {
            return;
        }
        try {
            String sb2 = String.format("%s\r\n", sb);
            this.writer.write(sb2);
            this.writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void debug(String msg) {
        this.log(Level.DEBUG, msg);
    }

    public void debug(String format, Object ... objs) {
        this.debug(String.format(format, objs));
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void info(String format, Object ... objs) {
        this.info(String.format(format, objs));
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void warning(String format, Object ... objs) {
        this.warning(String.format(format, objs));
    }

    public void warning(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        this.log(Level.WARNING, "Exception: " + sw);
    }

    public static enum Level {
        DEBUG("DEBUG", false),
        INFO("INFO", true),
        WARNING("WARNING", true);

        final String name;
        final boolean display;

        private Level(String name, boolean display) {
            this.name = name;
            this.display = display;
        }

        public String getName() {
            return this.name;
        }

        public boolean display() {
            return this.display;
        }
    }
}

