/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public final class InventoryUtils {
    private InventoryUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static NBTTagCompound writeInventory(NonNullList<ItemStack> inventory) {
        NBTTagList items = new NBTTagList();
        for (int slot = 0; slot < inventory.size(); ++slot) {
            if (((ItemStack)inventory.get(slot)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", slot);
            ((ItemStack)inventory.get(slot)).func_77955_b(itemTag);
            items.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Items", (NBTBase)items);
        tag.func_74768_a("Size", inventory.size());
        return tag;
    }

    public static NonNullList<ItemStack> readInventory(NBTTagCompound tag) {
        NonNullList stacks = NonNullList.func_191197_a((int)tag.func_74762_e("Size"), (Object)ItemStack.field_190927_a);
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            int slot = itemTag.func_74762_e("Slot");
            stacks.set(slot, (Object)new ItemStack(itemTag));
        }
        return stacks;
    }

    public static List<IContainerListener> getListeners(Container container) {
        return container.field_75149_d;
    }

    public static boolean hasListener(Container container, IContainerListener listener) {
        return InventoryUtils.getListeners(container).contains(listener);
    }
}

