/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.Utils;
import com.mojang.authlib.GameProfile;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.oredict.OreDictionary;

@RitualRegister(value="magnetism")
public class RitualMagnetic
extends Ritual {
    public static final String PLACEMENT_RANGE = "placementRange";
    public BlockPos lastPos;
    private FakePlayer fakePlayer;

    public RitualMagnetic() {
        super("ritualMagnetic", 0, 5000, "ritual.bloodmagic.magneticRitual");
        this.addBlockRange(PLACEMENT_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 1, -1), 3));
        this.setMaximumVolumeAndDistanceOfRange(PLACEMENT_RANGE, 50, 4, 4);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        Vec3d MRSpos = new Vec3d((Vec3i)masterRitualStone.getBlockPos());
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        AreaDescriptor placementRange = masterRitualStone.getBlockRange(PLACEMENT_RANGE);
        BlockPos replacement = pos;
        boolean replace = false;
        for (BlockPos offset : placementRange.getContainedPositions(pos)) {
            if (!world.func_175623_d(offset)) continue;
            replacement = offset;
            replace = true;
            break;
        }
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        int radius = this.getRadius(downState.func_177230_c());
        if (replace) {
            int j = -1;
            int i = -radius;
            int k = -radius;
            if (this.lastPos != null) {
                j = this.lastPos.func_177956_o();
                i = Math.min(radius, Math.max(-radius, this.lastPos.func_177958_n()));
                k = Math.min(radius, Math.max(-radius, this.lastPos.func_177952_p()));
            }
            if (j + pos.func_177956_o() >= 0) {
                while (i <= radius) {
                    while (k <= radius) {
                        BlockPos newPos = pos.func_177982_a(i, j, k);
                        Vec3d newPosVector = new Vec3d((Vec3i)newPos);
                        IBlockState state = world.func_180495_p(newPos);
                        RayTraceResult fakeRayTrace = world.func_72901_a(MRSpos, newPosVector, false);
                        ItemStack checkStack = state.func_177230_c().getPickBlock(state, fakeRayTrace, world, newPos, (EntityPlayer)this.getFakePlayer((WorldServer)world));
                        if (RitualMagnetic.isBlockOre(checkStack)) {
                            Utils.swapLocations(world, newPos, world, replacement);
                            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                            this.lastPos = new BlockPos(i, j, ++k);
                            return;
                        }
                        ++k;
                    }
                    ++i;
                    k = -radius;
                }
                i = -radius;
                this.lastPos = new BlockPos(i, --j, k);
                return;
            }
            j = -1;
            this.lastPos = new BlockPos(i, j, k);
        }
    }

    public int getRadius(Block block) {
        if (block == Blocks.field_150339_S) {
            return 7;
        }
        if (block == Blocks.field_150340_R) {
            return 15;
        }
        if (block == Blocks.field_150484_ah) {
            return 31;
        }
        return 3;
    }

    @Override
    public int getRefreshTime() {
        return 40;
    }

    @Override
    public int getRefreshCost() {
        return 50;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 2, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 2, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualMagnetic();
    }

    private FakePlayer getFakePlayer(WorldServer world) {
        return this.fakePlayer == null ? (this.fakePlayer = FakePlayerFactory.get((WorldServer)world, (GameProfile)new GameProfile(null, "bloodmagic_ritual_magnetic"))) : this.fakePlayer;
    }

    public static boolean isBlockOre(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            String oreName = OreDictionary.getOreName((int)id);
            if (!oreName.contains("ore")) continue;
            return true;
        }
        return false;
    }
}

