/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.ar.com.hjg.pngj.pixels;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import me.superckl.biometweaker.ar.com.hjg.pngj.IImageLine;
import me.superckl.biometweaker.ar.com.hjg.pngj.IImageLineFactory;
import me.superckl.biometweaker.ar.com.hjg.pngj.ImageInfo;
import me.superckl.biometweaker.ar.com.hjg.pngj.ImageLineByte;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageLineBufferedImage
implements IImageLine {
    public final ImageInfo imgInfo;
    private final BufferedImage image;
    private int rowNumber = -1;
    private boolean hasAlpha;
    private int rowLength;
    private boolean bgrOrder;
    private byte[] bytes;

    public ImageLineBufferedImage(ImageInfo imgInfo, BufferedImage bi, byte[] bytesdata) {
        this.imgInfo = imgInfo;
        this.image = bi;
        this.bytes = bytesdata;
        this.hasAlpha = this.image.getColorModel().hasAlpha();
        this.rowLength = this.hasAlpha ? this.image.getWidth() * 4 : this.image.getWidth() * 3;
        this.bgrOrder = ((ComponentSampleModel)this.image.getSampleModel()).getBandOffsets()[0] != 0;
    }

    public static IImageLineFactory<ImageLineByte> getFactory(ImageInfo iminfo) {
        return new IImageLineFactory<ImageLineByte>(){

            @Override
            public ImageLineByte createImageLine(ImageInfo iminfo) {
                return new ImageLineByte(iminfo);
            }
        };
    }

    @Override
    public void readFromPngRaw(byte[] raw, int len, int offset, int step) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void writeToPngRaw(byte[] raw) {
        if (this.imgInfo.bytesPerRow != this.rowLength) {
            throw new RuntimeException("??");
        }
        if (this.rowNumber < 0 || this.rowNumber >= this.imgInfo.rows) {
            throw new RuntimeException("???");
        }
        int bytesIdx = this.rowLength * this.rowNumber;
        int i = 1;
        if (this.hasAlpha) {
            if (this.bgrOrder) {
                while (i <= this.rowLength) {
                    byte a = this.bytes[bytesIdx++];
                    byte b = this.bytes[bytesIdx++];
                    byte g = this.bytes[bytesIdx++];
                    byte r = this.bytes[bytesIdx++];
                    raw[i++] = r;
                    raw[i++] = g;
                    raw[i++] = b;
                    raw[i++] = a;
                }
            } else {
                while (i <= this.rowLength) {
                    raw[i++] = this.bytes[bytesIdx++];
                    raw[i++] = this.bytes[bytesIdx++];
                    raw[i++] = this.bytes[bytesIdx++];
                    raw[i++] = this.bytes[bytesIdx++];
                }
            }
        } else if (this.bgrOrder) {
            while (i <= this.rowLength) {
                byte b = this.bytes[bytesIdx++];
                byte g = this.bytes[bytesIdx++];
                byte r = this.bytes[bytesIdx++];
                raw[i++] = r;
                raw[i++] = g;
                raw[i++] = b;
            }
        } else {
            while (i <= this.rowLength) {
                raw[i++] = this.bytes[bytesIdx++];
                raw[i++] = this.bytes[bytesIdx++];
                raw[i++] = this.bytes[bytesIdx++];
            }
        }
    }

    @Override
    public void endReadFromPngRaw() {
        throw new RuntimeException("not implemented");
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }
}

