/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network.packet.client;

import io.netty.buffer.ByteBuf;
import jds.bibliocraft.items.ItemBigBook;
import jds.bibliocraft.items.ItemClipboard;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.network.packet.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiblioDeskOpenGui
implements IMessage {
    BlockPos pos;
    ItemStack book;
    boolean canCraft;

    public BiblioDeskOpenGui() {
    }

    public BiblioDeskOpenGui(BlockPos pos, ItemStack book, boolean canCraft) {
        this.pos = pos;
        this.book = book;
        this.canCraft = canCraft;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.book = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.canCraft = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.book);
        buf.writeBoolean(this.canCraft);
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleBook(ItemStack book, int x, int y, int z, Item signedtest, boolean canCraft) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (signedtest instanceof ItemWrittenBook) {
            Utils.openWritingGUI((EntityPlayer)player, book, x, y, z, false);
        }
        if (signedtest instanceof ItemWritableBook) {
            Utils.openWritingGUI((EntityPlayer)player, book, x, y, z, true);
        }
        if (signedtest instanceof ItemClipboard) {
            Utils.openClipboardGUI(book, false, x, y, z);
        }
        if (signedtest instanceof ItemBigBook) {
            Utils.openBigBookGUI(book, x, y, z, player.getDisplayNameString());
        }
        if (signedtest instanceof ItemRecipeBook) {
            Utils.openRecipeBookGUI(book, x, y, z, -1, canCraft);
        }
        if (Loader.isModLoaded((String)"thaumcraft") && book.toString().contains("thaumonomicon")) {
            signedtest.func_77659_a(player.func_130014_f_(), (EntityPlayer)player, EnumHand.MAIN_HAND);
        }
        if (Loader.isModLoaded((String)"tailcraft") && book.toString().contains("railcraft.routing.table")) {
            signedtest.func_77659_a(player.func_130014_f_(), (EntityPlayer)player, EnumHand.MAIN_HAND);
        }
        if (Loader.isModLoaded((String)"craftguide") && book.toString().contains("craftguide")) {
            signedtest.func_77659_a(player.func_130014_f_(), (EntityPlayer)player, EnumHand.MAIN_HAND);
        }
        if (!Loader.isModLoaded((String)"botania") || book.func_77977_a().contentEquals("item.lexicon")) {
            // empty if block
        }
    }

    public static class Handler
    implements IMessageHandler<BiblioDeskOpenGui, IMessage> {
        public IMessage onMessage(BiblioDeskOpenGui message, MessageContext ctx) {
            int x = message.pos.func_177958_n();
            int y = message.pos.func_177956_o();
            int z = message.pos.func_177952_p();
            ItemStack book = message.book;
            boolean canCraft = message.canCraft;
            if (book != ItemStack.field_190927_a) {
                Item signedtest = book.func_77973_b();
                Minecraft.func_71410_x().func_152344_a(() -> BiblioDeskOpenGui.handleBook(book, x, y, z, signedtest, canCraft));
            }
            return null;
        }
    }
}

