/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors.nbt;

import betterquesting.api.misc.ICallback;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.callbacks.CallbackMulti;
import betterquesting.api2.client.gui.controls.callbacks.CallbackNBTPrimitive;
import betterquesting.api2.client.gui.controls.callbacks.CallbackNBTTagString;
import betterquesting.api2.client.gui.controls.filters.FieldFilterNumber;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.GuiTextEditor;
import betterquesting.client.gui2.editors.nbt.GuiEntitySelection;
import betterquesting.client.gui2.editors.nbt.GuiFluidSelection;
import betterquesting.client.gui2.editors.nbt.GuiItemSelection;
import betterquesting.client.gui2.editors.nbt.GuiNbtAdd;
import betterquesting.client.gui2.editors.nbt.GuiNbtEditor;
import betterquesting.client.gui2.editors.nbt.GuiNbtType;
import betterquesting.client.gui2.editors.nbt.callback.NbtEntityCallback;
import betterquesting.client.gui2.editors.nbt.callback.NbtFluidCallback;
import betterquesting.client.gui2.editors.nbt.callback.NbtItemCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public class PanelScrollingNBT
extends CanvasScrolling
implements IPEventListener {
    private NBTBase nbt;
    private final int btnEdit;
    private final int btnAdv;
    private final int btnInsert;
    private final int btnDelete;
    private final Stack<NBTBase> nbtStack = new Stack();
    private final Minecraft mc = Minecraft.func_71410_x();

    public PanelScrollingNBT(IGuiRect rect, NBTTagCompound tag, int btnEdit, int btnAdv, int btnInsert, int btnDelete) {
        this(rect, btnEdit, btnAdv, btnInsert, btnDelete);
        this.setNBT(tag);
    }

    public PanelScrollingNBT(IGuiRect rect, NBTTagList tag, int btnEdit, int btnAdv, int btnInsert, int btnDelete) {
        this(rect, btnEdit, btnAdv, btnInsert, btnDelete);
        this.setNBT(tag);
    }

    private PanelScrollingNBT(IGuiRect rect, int btnEdit, int btnAdv, int btnInsert, int btnDelete) {
        super(rect);
        this.btnEdit = btnEdit;
        this.btnAdv = btnAdv;
        this.btnInsert = btnInsert;
        this.btnDelete = btnDelete;
        PEventBroadcaster.INSTANCE.register(this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public PanelScrollingNBT setNBT(NBTTagCompound tag) {
        this.nbt = tag;
        this.refreshList();
        return this;
    }

    public PanelScrollingNBT setNBT(NBTTagList list) {
        this.nbt = list;
        this.refreshList();
        return this;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.refreshList();
    }

    private void refreshList() {
        this.resetCanvas();
        if (this.nbt == null) {
            return;
        }
        int preSX = this.getScrollX();
        int preSY = this.getScrollY();
        int width = this.getTransform().getWidth();
        int lw = (int)((float)width / 3.0f);
        int rw = width - lw;
        if (this.nbt.func_74732_a() == 10) {
            NBTTagCompound tag = (NBTTagCompound)this.nbt;
            ArrayList sortedKeys = new ArrayList(tag.func_150296_c());
            Collections.sort(sortedKeys);
            Iterator keys = sortedKeys.iterator();
            int i = 0;
            while (keys.hasNext()) {
                PanelButtonStorage<String> btn;
                PanelTextField<Object> text;
                PanelButtonStorage<String> btn2;
                String k = (String)keys.next();
                NBTBase entry = tag.func_74781_a(k);
                PanelTextBox name = new PanelTextBox(new GuiRectangle(0, i * 16 + 4, lw - 8, 12, 0), k).setAlignment(2);
                name.setColor(PresetColor.TEXT_MAIN.getColor());
                this.addPanel(name);
                if (entry.func_74732_a() == 10) {
                    btn2 = new PanelButtonStorage<String>(new GuiRectangle(lw, i * 16, rw - 48, 16, 0), this.btnEdit, this.getButtonTitle((NBTTagCompound)entry), k);
                    this.addPanel(btn2);
                    btn2 = new PanelButtonStorage<String>(new GuiRectangle(width - 48, i * 16, 16, 16, 0), this.btnAdv, "...", k);
                    this.addPanel(btn2);
                } else if (entry.func_74732_a() == 9) {
                    btn2 = new PanelButtonStorage<String>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), this.btnEdit, "List...", k);
                    this.addPanel(btn2);
                } else if (entry.func_74732_a() == 8) {
                    text = new PanelTextField<String>(new GuiRectangle(lw, i * 16, rw - 48, 16, 0), "" + ((NBTTagString)entry).func_150285_a_(), FieldFilterString.INSTANCE);
                    text.setCallback(new CallbackNBTTagString(tag, k)).setMaxLength(Integer.MAX_VALUE);
                    this.addPanel(text);
                    btn = new PanelButtonStorage<String>(new GuiRectangle(width - 48, i * 16, 16, 16, 0), this.btnEdit, "Aa", k);
                    this.addPanel(btn);
                } else if (entry.func_74732_a() == 1) {
                    text = new PanelTextField<Byte>(new GuiRectangle(lw, i * 16, rw / 2, 16, 0), "" + ((NBTPrimitive)entry).func_150290_f(), FieldFilterNumber.BYTE);
                    text.setMaxLength(Integer.MAX_VALUE);
                    this.addPanel(text);
                    btn = new PanelButtonStorage<String>(new GuiRectangle(lw + rw / 2, i * 16, (int)Math.ceil((float)rw / 2.0f) - 32, 16, 0), this.btnEdit, ((NBTPrimitive)entry).func_150290_f() > 0 ? "true" : "false", k);
                    this.addPanel(btn);
                    text.setMaxLength(Integer.MAX_VALUE).setCallback(new CallbackMulti(new CallbackNBTPrimitive<Byte>(tag, k, Byte.class), value -> btn.setText(value > 0 ? "true" : "false")));
                    btn.setCallback(value -> {
                        boolean flag = tag.func_74771_c(value) > 0;
                        tag.func_74774_a(value, flag ? (byte)0 : (byte)1);
                        text.setText(flag ? "0" : "1");
                        btn.setText(flag ? "false" : "true");
                    });
                } else if (entry.func_74732_a() > 1 && entry.func_74732_a() < 7) {
                    switch (entry.func_74732_a()) {
                        case 2: {
                            text = new PanelTextField<Short>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), "" + ((NBTPrimitive)entry).func_150289_e(), FieldFilterNumber.SHORT);
                            text.setCallback(new CallbackNBTPrimitive<Short>(tag, k, Short.class)).setMaxLength(Integer.MAX_VALUE);
                            this.addPanel(text);
                            break;
                        }
                        case 3: {
                            text = new PanelTextField<Integer>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), "" + ((NBTPrimitive)entry).func_150287_d(), FieldFilterNumber.INT);
                            text.setCallback(new CallbackNBTPrimitive<Integer>(tag, k, Integer.class)).setMaxLength(Integer.MAX_VALUE);
                            this.addPanel(text);
                            break;
                        }
                        case 4: {
                            text = new PanelTextField<Long>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), "" + ((NBTPrimitive)entry).func_150291_c(), FieldFilterNumber.LONG);
                            text.setCallback(new CallbackNBTPrimitive<Long>(tag, k, Long.class)).setMaxLength(Integer.MAX_VALUE);
                            this.addPanel(text);
                            break;
                        }
                        case 5: {
                            text = new PanelTextField<Float>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), "" + ((NBTPrimitive)entry).func_150288_h(), FieldFilterNumber.FLOAT);
                            text.setCallback(new CallbackNBTPrimitive<Float>(tag, k, Float.class)).setMaxLength(Integer.MAX_VALUE);
                            this.addPanel(text);
                            break;
                        }
                        case 6: {
                            text = new PanelTextField<Double>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), "" + ((NBTPrimitive)entry).func_150286_g(), FieldFilterNumber.DOUBLE);
                            text.setCallback(new CallbackNBTPrimitive<Double>(tag, k, Double.class)).setMaxLength(Integer.MAX_VALUE);
                            this.addPanel(text);
                            break;
                        }
                    }
                } else {
                    PanelTextBox err = new PanelTextBox(new GuiRectangle(lw, i * 16 + 4, rw - 48, 12, 0), entry.getClass().getSimpleName() + " Not Supported Yet").setAlignment(1);
                    err.setColor(PresetColor.TEXT_MAIN.getColor());
                    this.addPanel(err);
                }
                PanelButtonStorage<String> btnI = new PanelButtonStorage<String>(new GuiRectangle(width - 32, i * 16, 16, 16, 0), this.btnInsert, "+", k);
                btnI.setTextHighlight(new GuiColorStatic(128, 128, 128, 255), new GuiColorStatic(0, 255, 0, 255), new GuiColorStatic(0, 255, 0, 255));
                this.addPanel(btnI);
                PanelButtonStorage<String> btnD = new PanelButtonStorage<String>(new GuiRectangle(width - 16, i * 16, 16, 16, 0), this.btnDelete, "x", k);
                btnD.setTextHighlight(new GuiColorStatic(128, 128, 128, 255), new GuiColorStatic(255, 0, 0, 255), new GuiColorStatic(255, 0, 0, 255));
                this.addPanel(btnD);
                ++i;
            }
            this.addPanel(new PanelGeneric(new GuiRectangle(0, i * 16, width - 32, 16, 0), null));
            PanelButtonStorage<String> btnI = new PanelButtonStorage<String>(new GuiRectangle(width - 32, i * 16, 16, 16, 0), this.btnInsert, "+", "");
            btnI.setTextHighlight(new GuiColorStatic(128, 128, 128, 255), new GuiColorStatic(0, 255, 0, 255), new GuiColorStatic(0, 255, 0, 255));
            this.addPanel(btnI);
        } else if (this.nbt.func_74732_a() == 9) {
            int i;
            NBTTagList list = (NBTTagList)this.nbt;
            for (i = 0; i < list.func_74745_c(); ++i) {
                PanelButtonStorage<Integer> btn;
                PanelTextField<Object> text;
                PanelButtonStorage<Integer> btn3;
                NBTBase entry = list.func_179238_g(i);
                PanelTextBox name = new PanelTextBox(new GuiRectangle(0, i * 16 + 4, lw - 8, 16, 0), "#" + i).setAlignment(2);
                name.setColor(PresetColor.TEXT_MAIN.getColor());
                this.addPanel(name);
                if (entry.func_74732_a() == 10) {
                    btn3 = new PanelButtonStorage<Integer>(new GuiRectangle(lw, i * 16, rw - 48, 16, 0), this.btnEdit, this.getButtonTitle((NBTTagCompound)entry), i);
                    this.addPanel(btn3);
                    btn3 = new PanelButtonStorage<Integer>(new GuiRectangle(width - 48, i * 16, 16, 16, 0), this.btnAdv, "...", i);
                    this.addPanel(btn3);
                } else if (entry.func_74732_a() == 9) {
                    btn3 = new PanelButtonStorage<Integer>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), this.btnEdit, "List...", i);
                    this.addPanel(btn3);
                } else if (entry.func_74732_a() == 8) {
                    text = new PanelTextField<String>(new GuiRectangle(lw, i * 16, rw - 48, 16, 0), "" + ((NBTTagString)entry).func_150285_a_(), FieldFilterString.INSTANCE);
                    text.setCallback(new CallbackNBTTagString(list, i)).setMaxLength(Integer.MAX_VALUE);
                    this.addPanel(text);
                    btn = new PanelButtonStorage<Integer>(new GuiRectangle(width - 48, i * 16, 16, 16, 0), this.btnEdit, "Aa", i);
                    this.addPanel(btn);
                } else if (entry.func_74732_a() == 1) {
                    text = new PanelTextField<Byte>(new GuiRectangle(lw, i * 16, rw / 2, 16, 0), "" + ((NBTPrimitive)entry).func_150290_f(), FieldFilterNumber.BYTE);
                    this.addPanel(text);
                    btn = new PanelButtonStorage<Integer>(new GuiRectangle(lw + rw / 2, i * 16, (int)Math.ceil((float)rw / 2.0f) - 32, 16, 0), this.btnEdit, ((NBTPrimitive)entry).func_150290_f() > 0 ? "true" : "false", i);
                    this.addPanel(btn);
                    text.setMaxLength(Integer.MAX_VALUE).setCallback(new CallbackMulti(new CallbackNBTPrimitive<Byte>(list, i, Byte.class), value -> btn.setText(value > 0 ? "true" : "false")));
                    btn.setCallback(value -> {
                        boolean flag = ((NBTTagByte)list.func_179238_g(value.intValue())).func_150290_f() > 0;
                        list.func_150304_a(value.intValue(), (NBTBase)new NBTTagByte(flag ? (byte)0 : (byte)1));
                        text.setText(flag ? "0" : "1");
                        btn.setText(flag ? "false" : "true");
                    });
                } else if (entry.func_74732_a() > 1 && entry.func_74732_a() < 7) {
                    switch (entry.func_74732_a()) {
                        case 2: {
                            text = new PanelTextField<Short>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), "" + ((NBTPrimitive)entry).func_150289_e(), FieldFilterNumber.SHORT);
                            text.setCallback(new CallbackNBTPrimitive<Short>(list, i, Short.class)).setMaxLength(Integer.MAX_VALUE);
                            this.addPanel(text);
                            break;
                        }
                        case 3: {
                            text = new PanelTextField<Integer>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), "" + ((NBTPrimitive)entry).func_150287_d(), FieldFilterNumber.INT);
                            text.setCallback(new CallbackNBTPrimitive<Integer>(list, i, Integer.class)).setMaxLength(Integer.MAX_VALUE);
                            this.addPanel(text);
                            break;
                        }
                        case 4: {
                            text = new PanelTextField<Long>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), "" + ((NBTPrimitive)entry).func_150291_c(), FieldFilterNumber.LONG);
                            text.setCallback(new CallbackNBTPrimitive<Long>(list, i, Long.class)).setMaxLength(Integer.MAX_VALUE);
                            this.addPanel(text);
                            break;
                        }
                        case 5: {
                            text = new PanelTextField<Float>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), "" + ((NBTPrimitive)entry).func_150288_h(), FieldFilterNumber.FLOAT);
                            text.setCallback(new CallbackNBTPrimitive<Float>(list, i, Float.class)).setMaxLength(Integer.MAX_VALUE);
                            this.addPanel(text);
                            break;
                        }
                        case 6: {
                            text = new PanelTextField<Double>(new GuiRectangle(lw, i * 16, rw - 32, 16, 0), "" + ((NBTPrimitive)entry).func_150286_g(), FieldFilterNumber.DOUBLE);
                            text.setCallback(new CallbackNBTPrimitive<Double>(list, i, Double.class)).setMaxLength(Integer.MAX_VALUE);
                            this.addPanel(text);
                            break;
                        }
                    }
                } else {
                    PanelTextBox err = new PanelTextBox(new GuiRectangle(lw, i * 16 + 4, rw - 48, 12, 0), entry.getClass().getSimpleName() + " Not Supported Yet").setAlignment(1);
                    err.setColor(PresetColor.TEXT_MAIN.getColor());
                    this.addPanel(err);
                }
                PanelButtonStorage<Integer> btnI = new PanelButtonStorage<Integer>(new GuiRectangle(width - 32, i * 16, 16, 16, 0), this.btnInsert, "+", i);
                btnI.setTextHighlight(new GuiColorStatic(128, 128, 128, 255), new GuiColorStatic(0, 255, 0, 255), new GuiColorStatic(0, 255, 0, 255));
                this.addPanel(btnI);
                PanelButtonStorage<Integer> btnD = new PanelButtonStorage<Integer>(new GuiRectangle(width - 16, i * 16, 16, 16, 0), this.btnDelete, "x", i);
                btnD.setTextHighlight(new GuiColorStatic(128, 128, 128, 255), new GuiColorStatic(255, 0, 0, 255), new GuiColorStatic(255, 0, 0, 255));
                this.addPanel(btnD);
            }
            this.addPanel(new PanelGeneric(new GuiRectangle(0, i * 16, width - 32, 16, 0), null));
            PanelButtonStorage<Integer> btnI = new PanelButtonStorage<Integer>(new GuiRectangle(width - 32, i * 16, 16, 16, 0), this.btnInsert, "+", i);
            btnI.setTextHighlight(new GuiColorStatic(128, 128, 128, 255), new GuiColorStatic(0, 255, 0, 255), new GuiColorStatic(0, 255, 0, 255));
            this.addPanel(btnI);
        }
        this.setScrollX(preSX);
        this.setScrollY(preSY);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        NBTBase entry;
        if (this.nbt == null) {
            return;
        }
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() != this.btnEdit && btn.getButtonID() != this.btnAdv && btn.getButtonID() != this.btnInsert && btn.getButtonID() != this.btnDelete) {
            return;
        }
        if (this.nbt.func_74732_a() == 10) {
            entry = ((NBTTagCompound)this.nbt).func_74781_a((String)((PanelButtonStorage)btn).getStoredValue());
        } else if (this.nbt.func_74732_a() == 9) {
            entry = ((NBTTagList)this.nbt).func_179238_g(((Integer)((PanelButtonStorage)btn).getStoredValue()).intValue());
        } else {
            throw new RuntimeException("Invalid NBT tag type!");
        }
        if (btn.getButtonID() == this.btnEdit) {
            if (entry.func_74732_a() == 10) {
                NBTTagCompound tag = (NBTTagCompound)entry;
                if (JsonHelper.isItem(tag)) {
                    this.mc.func_147108_a((GuiScreen)new GuiItemSelection(this.mc.field_71462_r, tag, (ICallback<BigItemStack>)new NbtItemCallback(tag)));
                } else if (JsonHelper.isFluid(tag)) {
                    this.mc.func_147108_a((GuiScreen)new GuiFluidSelection(this.mc.field_71462_r, tag, (ICallback<FluidStack>)new NbtFluidCallback(tag)));
                } else if (JsonHelper.isEntity(tag)) {
                    this.mc.func_147108_a((GuiScreen)new GuiEntitySelection(this.mc.field_71462_r, tag, (ICallback<Entity>)new NbtEntityCallback(tag)));
                } else {
                    this.mc.func_147108_a((GuiScreen)new GuiNbtEditor(this.mc.field_71462_r, tag, null));
                }
            } else if (entry.func_74732_a() == 9) {
                this.mc.func_147108_a((GuiScreen)new GuiNbtEditor(this.mc.field_71462_r, (NBTTagList)entry, null));
            } else if (entry.func_74732_a() == 8) {
                if (this.nbt.func_74732_a() == 10) {
                    this.mc.func_147108_a((GuiScreen)new GuiTextEditor(this.mc.field_71462_r, ((NBTTagString)entry).func_150285_a_(), new CallbackNBTTagString((NBTTagCompound)this.nbt, (String)((PanelButtonStorage)btn).getStoredValue())));
                } else if (this.nbt.func_74732_a() == 9) {
                    this.mc.func_147108_a((GuiScreen)new GuiTextEditor(this.mc.field_71462_r, ((NBTTagString)entry).func_150285_a_(), new CallbackNBTTagString((NBTTagList)this.nbt, (Integer)((PanelButtonStorage)btn).getStoredValue())));
                }
            } else if (entry.func_74732_a() == 7 || entry.func_74732_a() == 11 || entry.func_74732_a() == 12) {
                throw new UnsupportedOperationException("NBTTagByteArray, NBTTagIntArray and NBTTagLongArray are not currently supported yet");
            }
        } else if (btn.getButtonID() == this.btnAdv) {
            if (entry.func_74732_a() == 10) {
                this.mc.func_147108_a((GuiScreen)new GuiNbtType(this.mc.field_71462_r, (NBTTagCompound)entry));
            } else if (entry.func_74732_a() == 9) {
                this.mc.func_147108_a((GuiScreen)new GuiNbtEditor(this.mc.field_71462_r, (NBTTagList)entry, null));
            }
        } else if (btn.getButtonID() == this.btnInsert) {
            if (this.nbt.func_74732_a() == 10) {
                this.mc.func_147108_a((GuiScreen)new GuiNbtAdd(this.mc.field_71462_r, (NBTTagCompound)this.nbt));
            } else if (this.nbt.func_74732_a() == 9) {
                this.mc.func_147108_a((GuiScreen)new GuiNbtAdd(this.mc.field_71462_r, (NBTTagList)this.nbt, (Integer)((PanelButtonStorage)btn).getStoredValue()));
            }
        } else if (btn.getButtonID() == this.btnDelete) {
            if (this.nbt.func_74732_a() == 10) {
                ((NBTTagCompound)this.nbt).func_82580_o((String)((PanelButtonStorage)btn).getStoredValue());
                this.refreshList();
            } else if (this.nbt.func_74732_a() == 9) {
                ((NBTTagList)this.nbt).func_74744_a(((Integer)((PanelButtonStorage)btn).getStoredValue()).intValue());
                this.refreshList();
            }
        }
    }

    private String getButtonTitle(NBTTagCompound tag) {
        if (JsonHelper.isItem(tag)) {
            BigItemStack stack = JsonHelper.JsonToItemStack(tag);
            return QuestTranslation.translate("betterquesting.btn.item", new Object[0]) + ": " + stack.getBaseStack().func_82833_r();
        }
        if (JsonHelper.isFluid(tag)) {
            FluidStack fluid = JsonHelper.JsonToFluidStack(tag);
            return QuestTranslation.translate("betterquesting.btn.fluid", new Object[0]) + ": " + fluid.getLocalizedName();
        }
        if (JsonHelper.isEntity(tag)) {
            Entity entity = JsonHelper.JsonToEntity(tag, (World)this.mc.field_71441_e);
            return QuestTranslation.translate("betterquesting.btn.entity", new Object[0]) + ": " + entity.func_70005_c_();
        }
        return "Object...";
    }
}

