/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.blocks;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.IFluidTask;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.storage.DBEntry;
import betterquesting.blocks.SSItemHandler;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.QuestDatabase;
import betterquesting.storage.QuestSettings;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileSubmitStation
extends TileEntity
implements IFluidHandler,
ISidedInventory,
ITickable,
IFluidTankProperties {
    private final IItemHandler itemHandler;
    private final IFluidHandler fluidHandler;
    private NonNullList<ItemStack> itemStack = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private boolean needsUpdate = false;
    public UUID owner = null;
    public int questID = -1;
    public int taskID = -1;
    private DBEntry<IQuest> qCached;
    private static final int[] slotsForFace = new int[]{0, 1};

    public TileSubmitStation() {
        this.itemHandler = new SSItemHandler(this);
        this.fluidHandler = this;
    }

    public DBEntry<IQuest> getQuest() {
        IQuest tmp;
        if (this.questID < 0) {
            return null;
        }
        if (this.qCached == null && (tmp = (IQuest)QuestDatabase.INSTANCE.getValue(this.questID)) != null) {
            this.qCached = new DBEntry<IQuest>(this.questID, tmp);
        }
        return this.qCached;
    }

    public ITask getRawTask() {
        DBEntry<IQuest> q = this.getQuest();
        if (q == null || this.taskID < 0) {
            return null;
        }
        return (ITask)q.getValue().getTasks().getValue(this.taskID);
    }

    public IItemTask getItemTask() {
        ITask t = this.getRawTask();
        return t == null ? null : (t instanceof IItemTask ? (IItemTask)t : null);
    }

    public IFluidTask getFluidTask() {
        ITask t = this.getRawTask();
        return t == null ? null : (t instanceof IFluidTask ? (IFluidTask)t : null);
    }

    public int func_70302_i_() {
        return 2;
    }

    @Nonnull
    public ItemStack func_70301_a(int idx) {
        if (idx < 0 || idx >= this.itemStack.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.itemStack.get(idx);
    }

    @Nonnull
    public ItemStack func_70298_a(int idx, int amount) {
        return ItemStackHelper.func_188382_a(this.itemStack, (int)idx, (int)amount);
    }

    public void func_70299_a(int idx, @Nonnull ItemStack stack) {
        if (idx < 0 || idx >= this.itemStack.size()) {
            return;
        }
        this.itemStack.set(idx, (Object)stack);
    }

    @Nonnull
    public String func_70005_c_() {
        return BetterQuesting.submitStation.func_149732_F();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return (this.owner == null || player.func_110124_au().equals(this.owner)) && player.func_174818_b(this.field_174879_c) < 256.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int idx, @Nonnull ItemStack stack) {
        if (idx != 0 || !this.isSetup()) {
            return false;
        }
        IItemTask t = this.getItemTask();
        return t != null && ((ItemStack)this.itemStack.get(idx)).func_190926_b() && !t.isComplete(this.owner) && t.canAcceptItem(this.owner, this.getQuest(), stack);
    }

    public int fill(FluidStack fluid, boolean doFill) {
        int consumed;
        IFluidTask t = this.getFluidTask();
        if (!this.isSetup() || t == null) {
            return 0;
        }
        int amount = fluid.amount;
        int n = consumed = !doFill ? amount : 0;
        if (doFill) {
            FluidStack remainder = t.submitFluid(this.owner, this.getQuest(), fluid);
            int n2 = consumed = remainder != null ? amount - remainder.amount : amount;
            if (t.isComplete(this.owner)) {
                this.needsUpdate = true;
                this.reset();
                if (this.field_145850_b.func_73046_m() != null) {
                    this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
                }
            } else {
                this.needsUpdate = consumed > 0;
            }
        }
        return consumed;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill() {
        return true;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        IFluidTask t = this.getFluidTask();
        return t != null && !t.isComplete(this.owner) && t.canAcceptFluid(this.owner, this.getQuest(), new FluidStack(fluid, 1));
    }

    public boolean canDrain() {
        return false;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return false;
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public FluidStack getContents() {
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this};
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.isSetup() || QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            return;
        }
        long wtt = this.field_145850_b.func_82737_E();
        if (wtt % 5L == 0L && this.owner != null) {
            QuestCache qc;
            if (wtt % 20L == 0L) {
                this.qCached = null;
            }
            DBEntry<IQuest> q = this.getQuest();
            IItemTask t = this.getItemTask();
            MinecraftServer server = this.field_145850_b.func_73046_m();
            EntityPlayerMP player = server == null ? null : server.func_184103_al().func_177451_a(this.owner);
            QuestCache questCache = qc = player == null ? null : (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            if (q != null && t != null && !((ItemStack)this.itemStack.get(0)).func_190926_b() && ((ItemStack)this.itemStack.get(1)).func_190926_b()) {
                ItemStack inStack = ((ItemStack)this.itemStack.get(0)).func_77946_l();
                ItemStack beforeStack = ((ItemStack)this.itemStack.get(0)).func_77946_l();
                if (t.canAcceptItem(this.owner, this.getQuest(), inStack)) {
                    this.itemStack.set(0, (Object)t.submitItem(this.owner, this.getQuest(), inStack));
                    if (t.isComplete(this.owner) || !((ItemStack)this.itemStack.get(0)).equals(beforeStack)) {
                        this.needsUpdate = true;
                    }
                } else {
                    this.itemStack.set(1, (Object)inStack);
                    this.itemStack.set(0, (Object)ItemStack.field_190927_a);
                }
            }
            if (t != null && t.isComplete(this.owner)) {
                this.reset();
                this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                if (q != null && qc != null) {
                    qc.markQuestDirty(q.getID());
                }
                this.needsUpdate = false;
            }
        }
    }

    public void setupTask(UUID owner, IQuest quest, ITask task) {
        if (owner == null || quest == null || task == null) {
            this.reset();
            return;
        }
        this.questID = QuestDatabase.INSTANCE.getID(quest);
        this.qCached = new DBEntry<IQuest>(this.questID, quest);
        this.taskID = quest.getTasks().getID(task);
        if (this.questID < 0 || this.taskID < 0) {
            this.reset();
            return;
        }
        this.owner = owner;
        this.func_70296_d();
    }

    public boolean isSetup() {
        return this.owner != null && this.questID >= 0 && this.taskID >= 0;
    }

    public void reset() {
        this.owner = null;
        this.questID = -1;
        this.taskID = -1;
        this.qCached = null;
        this.func_70296_d();
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        ItemStackHelper.func_191283_b((NBTTagCompound)tags.func_74775_l("inventory"), this.itemStack);
        try {
            this.owner = UUID.fromString(tags.func_74779_i("owner"));
        }
        catch (Exception e) {
            this.reset();
            return;
        }
        this.questID = tags.func_74764_b("questID") ? tags.func_74762_e("questID") : -1;
        int n = this.taskID = tags.func_74764_b("task") ? tags.func_74762_e("task") : -1;
        if (!this.isSetup()) {
            this.reset();
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        tags.func_74778_a("owner", this.owner != null ? this.owner.toString() : "");
        tags.func_74768_a("questID", this.questID);
        tags.func_74768_a("task", this.taskID);
        tags.func_74782_a("inventory", (NBTBase)ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), this.itemStack));
        return tags;
    }

    @Nonnull
    public int[] func_180463_a(@Nullable EnumFacing side) {
        return slotsForFace;
    }

    public boolean func_180462_a(int slot, @Nonnull ItemStack stack, @Nullable EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, @Nonnull ItemStack stack, @Nullable EnumFacing side) {
        return slot == 1;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.itemStack, (int)index);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.itemStack.clear();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(BetterQuesting.submitStation.func_149732_F());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_191420_l() {
        return this.itemStack.isEmpty();
    }
}

