/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature;

import com.teammetallurgy.atum.blocks.wood.BlockBranch;
import com.teammetallurgy.atum.blocks.wood.BlockDeadwood;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenDeadwood
extends WorldGenAbstractTree {
    private static final IBlockState LOG = AtumBlocks.DEADWOOD_LOG.func_176223_P().func_177226_a((IProperty)BlockDeadwood.HAS_SCARAB, (Comparable)Boolean.valueOf(true));
    private static final IBlockState BRANCH = AtumBlocks.DEADWOOD_BRANCH.func_176223_P();

    public WorldGenDeadwood(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        int baseHeight = rand.nextInt(3) + 5;
        boolean doNotGenerate = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + baseHeight + 1 <= 256) {
            boolean isSoil;
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + baseHeight; ++y) {
                int k = 1;
                if (y == pos.func_177956_o()) {
                    k = 0;
                }
                if (y >= pos.func_177956_o() + 1 + baseHeight - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int x = pos.func_177958_n() - k; x <= pos.func_177958_n() + k && doNotGenerate; ++x) {
                    for (int z = pos.func_177952_p() - k; z <= pos.func_177952_p() + k && doNotGenerate; ++z) {
                        if (y >= 0 && y < world.func_72800_K()) {
                            if (this.isReplaceable(world, (BlockPos)mutableBlockPos.func_181079_c(x, y, z))) continue;
                            doNotGenerate = false;
                            continue;
                        }
                        doNotGenerate = false;
                    }
                }
            }
            if (!doNotGenerate) {
                return false;
            }
            BlockPos down = pos.func_177977_b();
            IBlockState state = world.func_180495_p(down);
            boolean bl = isSoil = state.func_177230_c() == AtumBlocks.SAND;
            if (isSoil && pos.func_177956_o() < world.func_72800_K() - baseHeight - 1) {
                ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
                for (int height = 0; height < baseHeight; ++height) {
                    BlockPos upN = pos.func_177981_b(height);
                    IBlockState state2 = world.func_180495_p(upN);
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)world, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)world, upN)) continue;
                    this.func_175903_a(world, pos.func_177981_b(height), LOG);
                    if (height <= 1) continue;
                    logs.add(pos.func_177981_b(height));
                }
                this.buildBranches(world, logs, rand);
                return true;
            }
            return false;
        }
        return false;
    }

    public void buildBranches(World world, List<BlockPos> logs, Random random) {
        LinkedList<ImmutablePair> queue = new LinkedList<ImmutablePair>();
        for (BlockPos pos : logs) {
            queue.add(new ImmutablePair((Object)pos, (Object)0));
        }
        BlockPos baseLog = (BlockPos)((Pair)queue.peek()).getLeft();
        int count = 0;
        HashSet<EnumFacing> choosenFacings = new HashSet<EnumFacing>();
        HashMap<EnumFacing, Integer> balancingCount = new HashMap<EnumFacing, Integer>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            balancingCount.put(facing, 0);
        }
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.poll();
            if (pair.getLeft() == null || pair.getRight() == null) continue;
            BlockPos pos = (BlockPos)pair.getLeft();
            int branchLength = (Integer)pair.getRight();
            choosenFacings.clear();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos nextPos;
                IBlockState prev;
                IBlockState curr;
                if (choosenFacings.contains(facing.func_176734_d()) || (curr = world.func_180495_p(pos)).func_177230_c() == BRANCH.func_177230_c() && curr.func_177229_b(BlockBranch.FACING) == facing.func_176734_d() && (prev = world.func_180495_p(pos.func_177971_a(facing.func_176734_d().func_176730_m()))).func_177230_c() == BRANCH.func_177230_c() && prev.func_177229_b(BlockBranch.FACING) == facing.func_176734_d()) continue;
                double dist = baseLog.func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                float probability = 0.8f;
                if (facing == EnumFacing.UP) {
                    probability = (float)((double)probability * 1.5);
                    if (world.func_180495_p(pos).func_177230_c() == LOG.func_177230_c()) {
                        probability = 0.0f;
                    }
                } else if (facing == EnumFacing.DOWN) {
                    probability = 0.0f;
                }
                probability = (float)((double)probability - 0.05 * dist);
                probability = (float)((double)probability - 0.002 * (double)count);
                probability = (float)((double)probability - 0.1 * (double)branchLength);
                probability = (float)((double)probability + 0.25 * (double)((Integer)balancingCount.get(facing)).intValue());
                if (!(random.nextFloat() < probability) || !world.func_175623_d(nextPos = pos.func_177971_a(facing.func_176730_m()))) continue;
                world.func_175656_a(nextPos, BRANCH.func_177226_a(BlockBranch.FACING, (Comparable)facing.func_176734_d()));
                queue.add(new ImmutablePair((Object)nextPos, (Object)(branchLength + 1)));
                ++count;
                choosenFacings.add(facing);
                if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) continue;
                if ((Integer)balancingCount.get(facing) > 0) {
                    balancingCount.put(facing, (Integer)balancingCount.get(facing) - 1);
                    continue;
                }
                balancingCount.put(facing.func_176734_d(), (Integer)balancingCount.get(facing.func_176734_d()) + 1);
            }
            if (queue.size() <= 100) continue;
            break;
        }
    }
}

