/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.Atum;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class TextureMapParticles
extends TextureMap {
    public TextureMapParticles(String basePath) {
        super(basePath, null, true);
    }

    public void func_110551_a(@Nonnull IResourceManager resourceManager) {
        this.func_110569_e();
        this.func_147631_c();
        this.func_110571_b(resourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void func_110571_b(@Nonnull IResourceManager resourceManager) {
        int size = Minecraft.func_71369_N();
        Stitcher stitcher = new Stitcher(size, size, 0, 0);
        this.field_94252_e.clear();
        this.field_94258_i.clear();
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Texture stitching", (int)this.field_110574_e.size());
        for (Map.Entry entry : this.field_110574_e.entrySet()) {
            TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)entry.getValue();
            ResourceLocation location = this.getResourceLocation(textureatlassprite);
            bar.step(location.func_110623_a());
            IResource iResource = null;
            if (textureatlassprite.hasCustomLoader(resourceManager, location)) {
                if (textureatlassprite.load(resourceManager, location, l -> (TextureAtlasSprite)this.field_110574_e.get(l.toString()))) {
                    continue;
                }
            } else {
                try {
                    PngSizeInfo sizeInfo = PngSizeInfo.func_188532_a((IResource)resourceManager.func_110536_a(location));
                    iResource = resourceManager.func_110536_a(location);
                    boolean flag = iResource.func_110526_a("animation") != null;
                    textureatlassprite.func_188538_a(sizeInfo, flag);
                    IOUtils.closeQuietly((Closeable)iResource);
                }
                catch (RuntimeException e) {
                    FMLClientHandler.instance().trackBrokenTexture(location, e.getMessage());
                    IOUtils.closeQuietly((Closeable)iResource);
                    continue;
                }
                catch (IOException e2) {
                    FMLClientHandler.instance().trackMissingTexture(location);
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeQuietly(iResource);
                    continue;
                }
            }
            stitcher.func_110934_a(textureatlassprite);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        this.field_94249_f.func_147963_d(0);
        stitcher.func_110934_a(this.field_94249_f);
        bar = ProgressManager.push((String)"Particle texture creation", (int)2);
        bar.step("Stitching");
        stitcher.func_94305_f();
        Atum.LOG.info("Created: {}x{} particle-atlas {}", (Object)stitcher.func_110935_a(), (Object)stitcher.func_110936_b(), (Object)this.field_94254_c);
        bar.step("Allocating GL texture");
        TextureUtil.func_180600_a((int)this.func_110552_b(), (int)0, (int)stitcher.func_110935_a(), (int)stitcher.func_110936_b());
        HashMap map = Maps.newHashMap((Map)this.field_110574_e);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        bar = ProgressManager.push((String)"Particle texture mipmap and upload", (int)stitcher.func_94309_g().size());
        for (TextureAtlasSprite sprite : stitcher.func_94309_g()) {
            bar.step(sprite.func_94215_i());
            if (sprite != this.field_94249_f && !this.generateMipmaps(resourceManager, sprite)) continue;
            String iconName = sprite.func_94215_i();
            map.remove(iconName);
            this.field_94252_e.put(iconName, sprite);
            try {
                TextureUtil.func_147955_a((int[][])sprite.func_147965_a(0), (int)sprite.func_94211_a(), (int)sprite.func_94216_b(), (int)sprite.func_130010_a(), (int)sprite.func_110967_i(), (boolean)false, (boolean)false);
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Stitching particle texture atlas");
                CrashReportCategory crashreportcategory = crashReport.func_85058_a("Particle texture being stitched together");
                crashreportcategory.func_71507_a("Particle atlas path", (Object)this.field_94254_c);
                crashreportcategory.func_71507_a("Particle sprite", (Object)sprite);
                throw new ReportedException(crashReport);
            }
            if (!sprite.func_130098_m()) continue;
            this.field_94258_i.add(sprite);
        }
        for (TextureAtlasSprite sprite : map.values()) {
            sprite.func_94217_a(this.field_94249_f);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateMipmaps(IResourceManager resourceManager, TextureAtlasSprite sprite) {
        block10: {
            ResourceLocation location = this.getResourceLocation(sprite);
            IResource iResource = null;
            if (!sprite.hasCustomLoader(resourceManager, location)) {
                boolean shouldGenerate;
                try {
                    iResource = resourceManager.func_110536_a(location);
                    sprite.func_188539_a(iResource, 1);
                    break block10;
                }
                catch (RuntimeException runtimeexception) {
                    Atum.LOG.error("Unable to parse metadata from {}", (Object)location, (Object)runtimeexception);
                    shouldGenerate = false;
                }
                catch (IOException ioexception) {
                    boolean shouldGenerate2;
                    Atum.LOG.error("Using missing texture, unable to load {}", (Object)location, (Object)ioexception);
                    boolean bl = shouldGenerate2 = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)iResource);
                }
                return shouldGenerate;
            }
        }
        try {
            sprite.func_147963_d(0);
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Applying mipmap");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Sprite being mipmapped");
            crashreportcategory.func_189529_a("Sprite name", () -> ((TextureAtlasSprite)sprite).func_94215_i());
            crashreportcategory.func_189529_a("Sprite size", () -> sprite.func_94211_a() + " x " + sprite.func_94216_b());
            crashreportcategory.func_189529_a("Sprite frames", () -> sprite.func_110970_k() + " frames");
            crashreportcategory.func_71507_a("Mipmap levels", (Object)0);
            throw new ReportedException(crashreport);
        }
    }

    private ResourceLocation getResourceLocation(TextureAtlasSprite sprite) {
        ResourceLocation location = new ResourceLocation(sprite.func_94215_i());
        return new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", this.field_94254_c, location.func_110623_a(), ".png"));
    }
}

