/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.wood;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.blocks.base.IRenderMapper;
import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLeave
extends BlockLeaves
implements IGrowable,
IRenderMapper,
IOreDictEntry {
    private static final Map<BlockAtumPlank.WoodType, Block> LEAVES = Maps.newEnumMap(BlockAtumPlank.WoodType.class);

    private BlockLeave() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    public static void registerLeaves() {
        for (BlockAtumPlank.WoodType type : BlockAtumPlank.WoodType.values()) {
            BlockLeave leave = new BlockLeave();
            LEAVES.put(type, (Block)leave);
            if (type == BlockAtumPlank.WoodType.DEADWOOD) {
                AtumRegistry.registerBlock((Block)leave, type.func_176610_l() + "_leaves", null);
                continue;
            }
            AtumRegistry.registerBlock((Block)leave, type.func_176610_l() + "_leaves");
        }
    }

    public static Block getLeave(BlockAtumPlank.WoodType type) {
        return LEAVES.get((Object)type);
    }

    public void func_180650_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random rand) {
        if (BlockAtumPlank.WoodType.byIndex(BlockAtumPlank.WoodType.values().length) == BlockAtumPlank.WoodType.PALM && !world.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
                if (!this.nearLog(world, pos)) {
                    super.func_180650_b(world, pos, state, rand);
                } else {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)), 4);
                }
            }
            if (this == BlockLeave.getLeave(BlockAtumPlank.WoodType.PALM) && world.field_73012_v.nextDouble() <= (double)0.05f && this.func_176473_a(world, pos, state, false)) {
                world.func_175656_a(pos.func_177977_b(), AtumBlocks.DATE_BLOCK.func_176223_P());
            }
        }
    }

    private boolean nearLog(World world, BlockPos pos) {
        for (BlockPos.MutableBlockPos mutableBlockPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(3, 0, 3), (BlockPos)pos.func_177982_a(-3, 0, -3))) {
            if (!(world.func_180495_p((BlockPos)mutableBlockPos).func_177230_c() instanceof BlockLog)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidLocation(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos check = pos.func_177972_a(facing);
            if (worldIn.func_180495_p(check).func_177230_c() != AtumBlocks.PALM_LOG) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 1) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    @Nonnull
    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.func_176837_a((int)0);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, @Nonnull ItemStack stack) {
        if (!world.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(Objects.requireNonNull(StatList.func_188055_a((Block)this)));
        } else {
            super.func_180657_a(world, player, pos, state, te, stack);
        }
    }

    protected int func_176232_d(IBlockState state) {
        return 10;
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return BlockAtumPlank.WoodType.byIndex(BlockAtumPlank.WoodType.values().length) == BlockAtumPlank.WoodType.PALM ? Item.func_150898_a((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(String.valueOf(state.func_177230_c().getRegistryName()).replace("leaves", "sapling"))))) : Items.field_190931_a;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack stack, IBlockAccess world, BlockPos pos, int fortune) {
        return Collections.singletonList(new ItemStack((Block)this));
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return new IProperty[]{field_176236_b, field_176237_a};
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_176223_P().func_185914_p();
    }

    @Override
    public void getOreDictEntries() {
        OreDictHelper.add((Block)this, "treeLeaves");
    }

    public boolean func_176473_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return BlockAtumPlank.WoodType.byIndex(BlockAtumPlank.WoodType.values().length) == BlockAtumPlank.WoodType.PALM && (Boolean)state.func_177229_b((IProperty)field_176237_a) != false && this.isValidLocation(world, pos.func_177977_b()) && world.func_175623_d(pos.func_177977_b());
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return BlockAtumPlank.WoodType.byIndex(BlockAtumPlank.WoodType.values().length) == BlockAtumPlank.WoodType.PALM;
    }

    public void func_176474_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.func_176473_a(world, pos, state, false) && rand.nextDouble() <= 0.5) {
            world.func_175656_a(pos.func_177977_b(), AtumBlocks.DATE_BLOCK.func_176223_P());
        }
    }
}

