/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.network.client;

import com.shinoow.abyssalcraft.common.network.AbstractMessage;
import com.shinoow.abyssalcraft.lib.util.ParticleUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class DisplayRoutesMessage
extends AbstractMessage.AbstractClientMessage<DisplayRoutesMessage> {
    private List<BlockPos[]> routes;
    private NBTTagCompound nbt = new NBTTagCompound();

    public DisplayRoutesMessage() {
    }

    public DisplayRoutesMessage(List<BlockPos[]> routes) {
        this.routes = routes;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.routes = new ArrayList<BlockPos[]>();
        this.nbt = ByteBufUtils.readTag((ByteBuf)buffer);
        NBTTagList list = this.nbt.func_150295_c("Routes", 9);
        for (NBTTagList list1 : list) {
            ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
            Iterator i1 = list1.iterator();
            while (i1.hasNext()) {
                temp.add(BlockPos.func_177969_a((long)((NBTTagLong)i1.next()).func_150291_c()));
            }
            this.routes.add(temp.toArray(new BlockPos[0]));
        }
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        NBTTagList list = new NBTTagList();
        for (BlockPos[] route : this.routes) {
            NBTTagList list1 = new NBTTagList();
            for (BlockPos pos : route) {
                list1.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
            }
            list.func_74742_a((NBTBase)list1);
        }
        this.nbt.func_74782_a("Routes", (NBTBase)list);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.nbt);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        BlockPos prevPos = null;
        if (!this.routes.isEmpty()) {
            for (BlockPos[] route : this.routes) {
                prevPos = null;
                for (BlockPos pos : route) {
                    if (prevPos == null) {
                        prevPos = pos;
                        continue;
                    }
                    ParticleUtil.spawnParticleLine(prevPos, pos, 15, (v1, v2) -> {
                        player.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, v1.field_72450_a * 0.1, 0.15, v1.field_72449_c * 0.1, new int[0]);
                        return false;
                    });
                    prevPos = pos;
                }
            }
        }
    }
}

