/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.transfer;

import com.shinoow.abyssalcraft.api.APIUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class ItemTransferConfiguration
implements INBTSerializable<NBTTagCompound> {
    private BlockPos[] route;
    private NonNullList<ItemStack> filter = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> subtypeFilter = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private EnumFacing exitFacing;
    private EnumFacing entryFacing;
    private boolean filterSubtypes;
    private boolean filterNBT;

    public ItemTransferConfiguration() {
    }

    public ItemTransferConfiguration(BlockPos[] route) {
        this.route = route;
    }

    public ItemTransferConfiguration setFilter(NonNullList<ItemStack> filter) {
        this.filter = filter;
        this.subtypeFilter = filter;
        return this;
    }

    public ItemTransferConfiguration setEntryFacing(EnumFacing facing) {
        this.entryFacing = facing;
        return this;
    }

    public ItemTransferConfiguration setExitFacing(EnumFacing facing) {
        this.exitFacing = facing;
        return this;
    }

    public ItemTransferConfiguration setFilterSubtypes(boolean filterSubtypes) {
        this.filterSubtypes = filterSubtypes;
        return this;
    }

    public ItemTransferConfiguration setFilterNBT(boolean filterNBT) {
        this.filterNBT = filterNBT;
        return this;
    }

    @Nonnull
    public BlockPos[] getRoute() {
        return this.route;
    }

    @Nonnull
    public NonNullList<ItemStack> getFilter() {
        return this.filterSubtypes ? this.subtypeFilter : this.filter;
    }

    @Nonnull
    public EnumFacing getExitFacing() {
        return this.exitFacing;
    }

    @Nonnull
    public EnumFacing getEntryFacing() {
        return this.entryFacing;
    }

    public boolean filterBySubtypes() {
        return this.filterSubtypes;
    }

    public boolean filterByNBT() {
        return this.filterNBT;
    }

    public void setupSubtypeFilter() {
        if (this.filterSubtypes) {
            for (ItemStack stack : this.subtypeFilter) {
                if (stack.func_190926_b() || !stack.func_77981_g()) continue;
                stack.func_77964_b(Short.MAX_VALUE);
            }
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("exitFacing", this.exitFacing.func_176745_a());
        nbt.func_74768_a("entryFacing", this.entryFacing.func_176745_a());
        NBTTagList list = new NBTTagList();
        Arrays.stream(this.route).map(b -> new NBTTagLong(b.func_177986_g())).forEach(arg_0 -> ((NBTTagList)list).func_74742_a(arg_0));
        nbt.func_74782_a("route", (NBTBase)list);
        new NBTTagCompound();
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.filter);
        nbt.func_74757_a("FilterSubtypes", this.filterSubtypes);
        nbt.func_74757_a("FilterNBT", this.filterNBT);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.exitFacing = EnumFacing.func_82600_a((int)nbt.func_74762_e("exitFacing"));
        this.entryFacing = EnumFacing.func_82600_a((int)nbt.func_74762_e("entryFacing"));
        NBTTagList list = nbt.func_150295_c("route", 4);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            positions.add(BlockPos.func_177969_a((long)((NBTTagLong)i.next()).func_150291_c()));
        }
        this.route = positions.toArray(new BlockPos[0]);
        this.filter = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        this.subtypeFilter = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.filter);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.subtypeFilter);
        this.filterSubtypes = nbt.func_74767_n("FilterSubtypes");
        this.filterNBT = nbt.func_74767_n("FilterNBT");
        this.setupSubtypeFilter();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemTransferConfiguration)) {
            return false;
        }
        ItemTransferConfiguration cfg = (ItemTransferConfiguration)obj;
        if (cfg.serializeNBT().toString().equals(this.serializeNBT().toString())) {
            return true;
        }
        boolean filtersMatch = false;
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>((Collection<ItemStack>)this.filter);
        temp.removeIf(ItemStack::func_190926_b);
        ArrayList<ItemStack> temp2 = new ArrayList<ItemStack>((Collection<ItemStack>)cfg.filter);
        temp2.removeIf(ItemStack::func_190926_b);
        int len1 = temp.size();
        int len2 = temp2.size();
        if (temp.size() == temp2.size()) {
            for (ItemStack stack : temp) {
                for (ItemStack stack2 : temp2) {
                    if (!APIUtils.areStacksEqual(stack2, stack)) continue;
                    stack.func_190920_e(0);
                    stack2.func_190920_e(0);
                }
            }
            if (temp.stream().allMatch(ItemStack::func_190926_b) && temp2.stream().allMatch(ItemStack::func_190926_b)) {
                filtersMatch = true;
            }
        }
        boolean desinationMatch = this.route[this.route.length - 1].equals((Object)cfg.route[cfg.route.length - 1]);
        boolean filterDiff = len1 == 0 && len2 != 0 || len1 != 0 && len2 == 0;
        return (filtersMatch || filterDiff) && desinationMatch;
    }
}

