/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.aenetvistool.data;

import appeng.api.implementations.parts.IPartCable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridConnectionVisitor;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridVisitor;
import appeng.api.parts.IPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.items.parts.PartType;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.PartP2PTunnel;
import codechicken.lib.colour.Colour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.aenetvistool.client.NetRenderManager;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.google.common.base.MoreObjects;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class NetworkData {
    private static final Map<PartType, Integer> P2P_INDEX_MAP = new HashMap<PartType, Integer>();
    private Map<IGridNode, NetNode> gridNodeMap = new HashMap<IGridNode, NetNode>();
    private Map<IGridNode, List<NetBus>> busNodeMap = new HashMap<IGridNode, List<NetBus>>();
    private List<IGridConnection> gridConnections = new ArrayList<IGridConnection>();
    public List<NetNode> nodes = new ArrayList<NetNode>();

    public static NetworkData scanNetwork(IGrid grid) {
        IGridNode pivot = grid.getPivot();
        NetworkData structure = new NetworkData();
        pivot.beginVisit((IGridVisitor)new NetVisitor(structure));
        structure.sortConnections();
        return structure;
    }

    public void sendToClient(EntityPlayer player) {
        PacketCustom packet = new PacketCustom((Object)"AE2NVChannel", 1);
        this.serialize((MCDataOutput)packet);
        packet.compress();
        packet.sendToPlayer(player);
    }

    private void sortConnections() {
        for (IGridConnection con : this.gridConnections) {
            AECableType typeB;
            AECableType typeA;
            EnumFacing facing;
            NetNode parent;
            NetNode target = null;
            if (this.gridNodeMap.containsKey(con.a())) {
                parent = this.gridNodeMap.get(con.a());
                facing = con.getDirection(con.b()).getFacing();
                target = this.gridNodeMap.get(con.b());
            } else {
                if (!this.gridNodeMap.containsKey(con.b())) continue;
                parent = this.gridNodeMap.get(con.b());
                facing = con.getDirection(con.a()).getFacing();
            }
            boolean isCable = false;
            IGridNode nodeA = con.a();
            IGridNode nodeB = con.b();
            IGridHost hostA = nodeA.getMachine();
            IGridHost hostB = nodeB.getMachine();
            if (hostA instanceof IPartCable) {
                isCable = true;
                typeA = ((IPartCable)hostA).getCableConnectionType();
            } else {
                typeA = hostA.getCableConnectionType(con.getDirection(nodeB));
            }
            if (hostB instanceof IPartCable) {
                isCable = true;
                typeB = ((IPartCable)hostB).getCableConnectionType();
            } else {
                typeB = hostB.getCableConnectionType(con.getDirection(nodeA));
            }
            boolean isDense = NetworkData.isDense(typeA) && NetworkData.isDense(typeB);
            NetConnection.Type type = NetConnection.Type.cableType(isCable, isDense);
            if (facing == null) {
                type = NetConnection.Type.INTERNAL;
            } else {
                facing = facing.func_176734_d();
            }
            NetNode.Type targetType = target == null ? NetNode.Type.MACHINE8 : target.type;
            parent.connections.add(new NetConnection(new GridPos(nodeA), new GridPos(nodeB), con.getUsedChannels(), type, targetType, facing));
        }
        for (IGridNode node : this.busNodeMap.keySet()) {
            if (!this.gridNodeMap.containsKey(node)) continue;
            NetNode n = this.gridNodeMap.get(node);
            for (NetBus bus : this.busNodeMap.get(node)) {
                n.busList.add(bus);
                if (bus.p2pTargets.isEmpty()) continue;
                n.isP2PSender = true;
            }
        }
    }

    public void serialize(MCDataOutput output) {
        output.writeVarInt(this.nodes.size());
        this.nodes.forEach(netNode -> netNode.serialize(output));
    }

    public static NetworkData deSerialize(MCDataInput input) {
        NetworkData netData = new NetworkData();
        int nNodes = input.readVarInt();
        for (int i = 0; i < nNodes; ++i) {
            netData.nodes.add(NetNode.deSerialize(input));
        }
        return netData;
    }

    private static boolean isDense(AECableType type) {
        return type == AECableType.DENSE_COVERED || type == AECableType.DENSE_SMART;
    }

    static {
        P2P_INDEX_MAP.put(PartType.P2P_TUNNEL_ME, 1);
        P2P_INDEX_MAP.put(PartType.P2P_TUNNEL_ITEMS, 2);
        P2P_INDEX_MAP.put(PartType.P2P_TUNNEL_REDSTONE, 3);
        P2P_INDEX_MAP.put(PartType.P2P_TUNNEL_IC2, 4);
        P2P_INDEX_MAP.put(PartType.P2P_TUNNEL_FE, 5);
        P2P_INDEX_MAP.put(PartType.P2P_TUNNEL_FLUIDS, 6);
        P2P_INDEX_MAP.put(PartType.P2P_TUNNEL_LIGHT, 7);
    }

    public static class NetVisitor
    implements IGridConnectionVisitor {
        private NetworkData netData;

        public NetVisitor(NetworkData netData) {
            this.netData = netData;
        }

        public void visitConnection(@Nonnull IGridConnection n) {
            this.netData.gridConnections.add(n);
        }

        public boolean visitNode(@Nonnull IGridNode n) {
            IGridHost host = n.getMachine();
            if (host instanceof AEBasePart && !(host instanceof IPartCable)) {
                AEPartLocation loc = ((AEBasePart)host).getSide();
                IPart internal = ((AEBasePart)host).getHost().getPart(AEPartLocation.INTERNAL);
                if (internal instanceof AEBasePart && loc != AEPartLocation.INTERNAL) {
                    IGridNode internalNode = internal.getGridNode();
                    PartType type = ((AEBasePart)host).getType();
                    int p2pIndex = P2P_INDEX_MAP.getOrDefault(type, 0);
                    NetBus bus = new NetBus(new PartPos(n, ((AEBasePart)host).getSide()), loc, p2pIndex, n.isActive());
                    if (host instanceof PartP2PTunnel && !((PartP2PTunnel)host).isOutput()) {
                        try {
                            TunnelCollection outputs = ((PartP2PTunnel)host).getOutputs();
                            for (PartP2PTunnel tunnel : outputs) {
                                bus.p2pTargets.add(new PartPos(tunnel.getLocation(), tunnel.getSide()));
                            }
                        }
                        catch (GridAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    this.netData.busNodeMap.computeIfAbsent(internalNode, node -> new ArrayList()).add(bus);
                }
            } else {
                NetNode.Type type = host instanceof IPartCable ? (NetworkData.isDense(((IPartCable)host).getCableConnectionType()) ? NetNode.Type.DENSE_CABLE : NetNode.Type.CABLE) : (NetworkData.isDense(host.getCableConnectionType(AEPartLocation.INTERNAL)) ? NetNode.Type.MACHINE32 : NetNode.Type.MACHINE8);
                NetNode node2 = new NetNode(type, new GridPos(n));
                this.netData.nodes.add(node2);
                this.netData.gridNodeMap.put(n, node2);
            }
            return true;
        }
    }

    public static class PartPos
    extends GridPos {
        public AEPartLocation partLocation;
        private Vec3D partPos = null;

        PartPos() {
        }

        public PartPos(BlockPos pos, int dim, AEPartLocation partLocation) {
            super(pos, dim);
            this.partLocation = partLocation;
        }

        public PartPos(DimensionalCoord coord, AEPartLocation partLocation) {
            super(coord);
            this.partLocation = partLocation;
        }

        public PartPos(IGridNode node, AEPartLocation partLocation) {
            super(node);
            this.partLocation = partLocation;
        }

        @Override
        public void serialize(MCDataOutput output) {
            output.writeEnum((Enum)this.partLocation);
            super.serialize(output);
        }

        @Override
        protected GridPos readDataInput(MCDataInput input) {
            this.partLocation = (AEPartLocation)input.readEnum(AEPartLocation.class);
            return super.readDataInput(input);
        }

        public static PartPos deSerialize(MCDataInput input) {
            return (PartPos)new PartPos().readDataInput(input);
        }

        public Vec3D getPartPos() {
            if (this.partPos == null) {
                this.partPos = Vec3D.getCenter((BlockPos)this.pos).add((double)this.partLocation.xOffset * 0.5, (double)this.partLocation.yOffset * 0.5, (double)this.partLocation.zOffset * 0.5);
            }
            return this.partPos;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("x", this.pos.func_177958_n()).add("y", this.pos.func_177956_o()).add("z", this.pos.func_177952_p()).add("dim", this.dim).add("side", (Object)this.partLocation).toString();
        }
    }

    public static class GridPos {
        public BlockPos pos;
        public int dim;

        GridPos() {
        }

        public GridPos(BlockPos pos, int dim) {
            this.pos = pos;
            this.dim = dim;
        }

        public GridPos(DimensionalCoord coord) {
            this(coord.getPos(), coord.getWorld().field_73011_w.getDimension());
        }

        public GridPos(IGridNode node) {
            this(node.getGridBlock().getLocation());
        }

        public void serialize(MCDataOutput output) {
            output.writePos(this.pos);
            output.writeVarInt(this.dim);
        }

        protected GridPos readDataInput(MCDataInput input) {
            this.pos = input.readPos();
            this.dim = input.readVarInt();
            return this;
        }

        public static GridPos deSerialize(MCDataInput input) {
            return new GridPos().readDataInput(input);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GridPos)) {
                return false;
            }
            GridPos other = (GridPos)obj;
            return other.pos.equals((Object)this.pos) && other.dim == this.dim;
        }

        public int hashCode() {
            return this.pos.hashCode();
        }
    }

    public static class NetBus {
        public PartPos pos;
        public int busType = -1;
        public AEPartLocation partLocation;
        public boolean isActive;
        public List<PartPos> p2pTargets = new ArrayList<PartPos>();
        private static Random rand = new Random();
        private float randColourOffset;
        private int randColour;
        private int offsetColour;

        public NetBus(PartPos pos, AEPartLocation partLocation, int busType, boolean isActive) {
            this.pos = pos;
            this.partLocation = partLocation;
            this.busType = busType;
            this.isActive = isActive;
        }

        NetBus() {
        }

        public void serialize(MCDataOutput output) {
            this.pos.serialize(output);
            output.writeByte(this.busType);
            output.writeEnum((Enum)this.partLocation);
            output.writeBoolean(this.isActive);
            output.writeVarShort(this.p2pTargets.size());
            this.p2pTargets.forEach(target -> target.serialize(output));
        }

        public static NetBus deSerialize(MCDataInput input) {
            NetBus bus = new NetBus();
            bus.pos = PartPos.deSerialize(input);
            bus.busType = input.readByte();
            bus.partLocation = (AEPartLocation)input.readEnum(AEPartLocation.class);
            bus.isActive = input.readBoolean();
            int nTargets = input.readVarShort();
            for (int i = 0; i < nTargets; ++i) {
                bus.p2pTargets.add(PartPos.deSerialize(input));
            }
            rand.setSeed(Objects.hash(bus.pos.pos.func_177986_g(), bus.partLocation));
            bus.randColourOffset = rand.nextFloat();
            bus.randColour = Color.HSBtoRGB(rand.nextFloat(), 1.0f, 1.0f);
            if (NetRenderManager.toolData != null && NetRenderManager.toolData.p2pColours.length == 7) {
                bus.offsetColour = NetRenderManager.toolData.p2pColours[bus.p2pColourIndex()];
                int[] c = Colour.unpack((int)bus.offsetColour);
                float[] hsb = Color.RGBtoHSB(c[1], c[2], c[3], new float[3]);
                float h = hsb[0] + (rand.nextFloat() - 0.5f) * 0.15f;
                if (h > 1.0f) {
                    h -= 1.0f;
                }
                if (h < 0.0f) {
                    h += 1.0f;
                }
                float s = MathHelper.clip((float)(hsb[1] + (rand.nextFloat() - 0.5f) * 0.35f), (float)0.0f, (float)1.0f);
                float b = MathHelper.clip((float)(hsb[2] + (rand.nextFloat() - 0.5f) * 0.2f), (float)0.0f, (float)1.0f);
                bus.offsetColour = Color.HSBtoRGB(h, s, b);
            }
            return bus;
        }

        private int p2pColourIndex() {
            return MathHelper.clip((int)(this.busType - 1), (int)0, (int)6);
        }

        public int getP2PColour() {
            if (NetRenderManager.toolData != null && NetRenderManager.toolData.p2pColours.length == 7) {
                if (NetRenderManager.toolData.randP2PColours) {
                    return this.randColour;
                }
                if (NetRenderManager.toolData.randP2PColourOffset) {
                    return this.offsetColour;
                }
                return NetRenderManager.toolData.p2pColours[this.p2pColourIndex()];
            }
            return 0;
        }
    }

    public static class NetConnection {
        public GridPos posA;
        public GridPos posB;
        public int channelsUsed;
        public Vec3D midPoint;
        public Type type;
        public NetNode.Type targetType;
        @Nullable
        public EnumFacing facing = null;

        public NetConnection(GridPos posA, GridPos posB, int channelsUsed, Type type, NetNode.Type targetType, EnumFacing facing) {
            this.posA = posA;
            this.posB = posB;
            this.channelsUsed = channelsUsed;
            this.type = type;
            this.targetType = targetType;
            this.facing = facing;
            Vec3D a = Vec3D.getCenter((BlockPos)posA.pos);
            Vec3D b = Vec3D.getCenter((BlockPos)posB.pos);
            this.midPoint = new Vec3D(a.x + (b.x - a.x) / 2.0, a.y + (b.y - a.y) / 2.0, a.z + (b.z - a.z) / 2.0);
        }

        NetConnection() {
        }

        public void serialize(MCDataOutput output) {
            this.posA.serialize(output);
            this.posB.serialize(output);
            output.writeVarShort(this.channelsUsed);
            output.writeEnum((Enum)this.type);
            output.writeEnum((Enum)this.targetType);
            output.writeByte(this.facing == null ? -1 : this.facing.ordinal());
        }

        public static NetConnection deSerialize(MCDataInput input) {
            NetConnection connection = new NetConnection();
            connection.posA = GridPos.deSerialize(input);
            connection.posB = GridPos.deSerialize(input);
            connection.channelsUsed = input.readVarShort();
            connection.type = (Type)input.readEnum(Type.class);
            connection.targetType = (NetNode.Type)input.readEnum(NetNode.Type.class);
            byte f = input.readByte();
            if (f != -1) {
                connection.facing = EnumFacing.values()[f];
            }
            Vec3D a = Vec3D.getCenter((BlockPos)connection.posA.pos);
            Vec3D b = Vec3D.getCenter((BlockPos)connection.posB.pos);
            connection.midPoint = new Vec3D(a.x + (b.x - a.x) / 2.0, a.y + (b.y - a.y) / 2.0, a.z + (b.z - a.z) / 2.0);
            return connection;
        }

        public static enum Type {
            CABLE,
            DENSE_CABLE,
            INTERNAL,
            P2P;


            public static Type cableType(boolean isCable, boolean isDense) {
                if (!isCable) {
                    return INTERNAL;
                }
                return isDense ? DENSE_CABLE : CABLE;
            }
        }
    }

    public static class NetNode {
        public Type type;
        public GridPos pos;
        public boolean isP2PSender = false;
        public List<NetConnection> connections = new ArrayList<NetConnection>();
        public List<NetBus> busList = new ArrayList<NetBus>();

        public NetNode(Type type, GridPos pos) {
            this.type = type;
            this.pos = pos;
        }

        public void serialize(MCDataOutput output) {
            output.writeEnum((Enum)this.type);
            this.pos.serialize(output);
            output.writeBoolean(this.isP2PSender);
            output.writeVarInt(this.connections.size());
            this.connections.forEach(con -> con.serialize(output));
            output.writeByte(this.busList.size());
            this.busList.forEach(bus -> bus.serialize(output));
        }

        public static NetNode deSerialize(MCDataInput input) {
            NetNode node = new NetNode((Type)input.readEnum(Type.class), GridPos.deSerialize(input));
            node.isP2PSender = input.readBoolean();
            int nCon = input.readVarInt();
            for (int i = 0; i < nCon; ++i) {
                node.connections.add(NetConnection.deSerialize(input));
            }
            int nBus = input.readByte();
            for (int i = 0; i < nBus; ++i) {
                node.busList.add(NetBus.deSerialize(input));
            }
            return node;
        }

        public boolean forceRender() {
            for (NetBus bus : this.busList) {
                if (bus.isActive && bus.busType <= 0) continue;
                return true;
            }
            return false;
        }

        public static enum Type {
            CABLE(3, 5),
            DENSE_CABLE(4, 4),
            MACHINE8(6, 2),
            MACHINE32(7, 1);

            public final int to;
            public final int so;

            private Type(int to, int so) {
                this.to = to;
                this.so = so;
            }
        }
    }
}

