/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import terrails.xnetgases.Constants;
import terrails.xnetgases.module.logic.ChemicalLogicConnectorSettings;
import terrails.xnetgases.module.logic.ChemicalLogicEnums;
import terrails.xnetgases.module.logic.ChemicalSensor;

public class ChemicalLogicChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    private int delay = 0;
    private int colors = 0;
    private List<Pair<SidedConsumer, ChemicalLogicConnectorSettings>> sensors = null;
    private List<Pair<SidedConsumer, ChemicalLogicConnectorSettings>> outputs = null;

    public JsonObject writeToJson() {
        return new JsonObject();
    }

    public void readFromNBT(CompoundTag tag) {
        this.delay = tag.m_128451_("delay");
        this.colors = tag.m_128451_("colors");
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128405_("delay", this.delay);
        tag.m_128405_("colors", this.colors);
    }

    public void tick(int channel, IControllerContext context) {
        ChemicalLogicConnectorSettings settings;
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 5 != 0) {
            return;
        }
        int d = this.delay / 5;
        this.updateCache(channel, context);
        Level level = context.getControllerWorld();
        this.colors = 0;
        for (Pair<SidedConsumer, ChemicalLogicConnectorSettings> entry : this.sensors) {
            settings = (ChemicalLogicConnectorSettings)((Object)entry.getValue());
            if (d % settings.getSpeed() != 0) {
                this.colors |= settings.getColorMask();
                continue;
            }
            int sensorColors = 0;
            BlockPos connectorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).consumerId());
            if (connectorPos != null) {
                boolean sense;
                Direction side = ((SidedConsumer)entry.getKey()).side();
                BlockPos pos = connectorPos.m_121945_(side);
                if (!LevelTools.isLoaded((Level)level, (BlockPos)pos)) {
                    this.colors |= settings.getColorMask();
                    continue;
                }
                boolean bl = sense = !this.checkRedstone(level, settings, connectorPos);
                if (sense && !context.matchColor(settings.getColorsMask())) {
                    sense = false;
                }
                if (sense) {
                    BlockEntity te = level.m_7702_(pos);
                    for (ChemicalSensor sensor : settings.getSensors()) {
                        if (!sensor.test(te, settings)) continue;
                        sensorColors |= 1 << sensor.getOutputColor().ordinal();
                    }
                }
            }
            settings.setColorMask(sensorColors);
            this.colors |= sensorColors;
        }
        for (Pair<SidedConsumer, ChemicalLogicConnectorSettings> entry : this.outputs) {
            BlockEntity te;
            BlockPos connectorPos;
            settings = (ChemicalLogicConnectorSettings)((Object)entry.getValue());
            if (d % settings.getSpeed() != 0 || (connectorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).consumerId())) == null) continue;
            Direction side = ((SidedConsumer)entry.getKey()).side();
            if (!LevelTools.isLoaded((Level)level, (BlockPos)connectorPos) || !((te = level.m_7702_(connectorPos)) instanceof ConnectorTileEntity)) continue;
            ConnectorTileEntity connectorTE = (ConnectorTileEntity)te;
            int powerOut = this.checkRedstone(level, settings, connectorPos) ? 0 : (!context.matchColor(settings.getColorsMask()) ? 0 : (settings.getRedstoneOut() == null ? 0 : settings.getRedstoneOut()));
            connectorTE.setPowerOut(side, powerOut);
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.sensors == null || this.outputs == null) {
            ChemicalLogicConnectorSettings con;
            this.sensors = new ArrayList<Pair<SidedConsumer, ChemicalLogicConnectorSettings>>();
            this.outputs = new ArrayList<Pair<SidedConsumer, ChemicalLogicConnectorSettings>>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (ChemicalLogicConnectorSettings)((Object)entry.getValue());
                if (con.getConnectorMode() == ChemicalLogicEnums.ConnectorMode.SENSOR) {
                    this.sensors.add((Pair<SidedConsumer, ChemicalLogicConnectorSettings>)Pair.of((Object)((SidedConsumer)entry.getKey()), (Object)((Object)con)));
                    continue;
                }
                this.outputs.add((Pair<SidedConsumer, ChemicalLogicConnectorSettings>)Pair.of((Object)((SidedConsumer)entry.getKey()), (Object)((Object)con)));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (ChemicalLogicConnectorSettings)((Object)entry.getValue());
                if (con.getConnectorMode() != ChemicalLogicEnums.ConnectorMode.OUTPUT) continue;
                this.outputs.add((Pair<SidedConsumer, ChemicalLogicConnectorSettings>)Pair.of((Object)((SidedConsumer)entry.getKey()), (Object)((Object)con)));
            }
        }
    }

    public void cleanCache() {
        this.sensors = null;
        this.outputs = null;
    }

    public int getColors() {
        return this.colors;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 11, 90, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String s) {
        return true;
    }

    public void createGui(IEditorGui iEditorGui) {
    }

    public void update(Map<String, Object> map) {
    }
}

