/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import javax.annotation.Nonnull;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.SidedPos;
import mcjty.xnet.XNet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class ConnectorClientInfo {
    @Nonnull
    private final SidedPos pos;
    @Nonnull
    private final ConsumerId consumerId;
    @Nonnull
    private final IChannelType channelType;
    @Nonnull
    private final IConnectorSettings connectorSettings;

    public ConnectorClientInfo(@Nonnull SidedPos pos, @Nonnull ConsumerId consumerId, @Nonnull IChannelType channelType, @Nonnull IConnectorSettings connectorSettings) {
        this.pos = pos;
        this.consumerId = consumerId;
        this.channelType = channelType;
        this.connectorSettings = connectorSettings;
    }

    public ConnectorClientInfo(@Nonnull FriendlyByteBuf buf) {
        this.pos = new SidedPos(buf.m_130135_(), OrientationTools.DIRECTION_VALUES[buf.readByte()]);
        this.consumerId = new ConsumerId(buf.readInt());
        IChannelType t = XNet.xNetApi.findType(buf.m_130136_(Short.MAX_VALUE));
        if (t == null) {
            throw new RuntimeException("Cannot happen!");
        }
        this.channelType = t;
        CompoundTag tag = buf.m_130260_();
        this.connectorSettings = this.channelType.createConnector(this.pos.side());
        this.connectorSettings.readFromNBT(tag);
    }

    public void writeToBuf(@Nonnull FriendlyByteBuf buf) {
        buf.m_130064_(this.pos.pos());
        buf.writeByte(this.pos.side().ordinal());
        buf.writeInt(this.consumerId.id());
        buf.m_130070_(this.channelType.getID());
        CompoundTag tag = new CompoundTag();
        this.connectorSettings.writeToNBT(tag);
        buf.m_130079_(tag);
    }

    @Nonnull
    public SidedPos getPos() {
        return this.pos;
    }

    @Nonnull
    public ConsumerId getConsumerId() {
        return this.consumerId;
    }

    @Nonnull
    public IConnectorSettings getConnectorSettings() {
        return this.connectorSettings;
    }
}

