/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFEntities;

public interface StructureHints {
    public static final String BOOK_AUTHOR = "twilightforest.book.author";

    default public ItemStack createHintBook() {
        ItemStack book = new ItemStack((ItemLike)Items.f_42615_);
        book.m_41784_().m_128379_("twilightforest:book", true);
        this.addBookInformation(book, new ListTag());
        return book;
    }

    default public void addBookInformation(ItemStack book, ListTag bookPages) {
        StructureHints.addTranslatedPages(bookPages, "twilightforest.book.unknown", 2);
        book.m_41700_("pages", (Tag)bookPages);
        book.m_41700_("author", (Tag)StringTag.m_129297_((String)BOOK_AUTHOR));
        book.m_41700_("title", (Tag)StringTag.m_129297_((String)"twilightforest.book.unknown"));
    }

    public static void addTranslatedPages(ListTag bookPages, String translationKey, int pageCount) {
        for (int i = 1; i <= pageCount; ++i) {
            bookPages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237115_((String)(translationKey + "." + i)))));
        }
    }

    default public void trySpawnHintMonster(Level world, Player player) {
        this.trySpawnHintMonster(world, player, player.m_20183_());
    }

    public void trySpawnHintMonster(Level var1, Player var2, BlockPos var3);

    default public boolean didSpawnHintMonster(Level world, Player player, BlockPos pos) {
        int dx = world.f_46441_.m_188503_(16) - world.f_46441_.m_188503_(16);
        int dy = world.f_46441_.m_188503_(4) - world.f_46441_.m_188503_(4);
        int dz = world.f_46441_.m_188503_(16) - world.f_46441_.m_188503_(16);
        Mob hinty = this.createHintMonster(world);
        hinty.m_20035_(pos.m_7918_(dx, dy, dz), 0.0f, 0.0f);
        if (hinty.m_6914_((LevelReader)world) && hinty.m_21574_().m_148306_((Entity)player)) {
            ItemStack book = this.createHintBook();
            hinty.m_8061_(EquipmentSlot.MAINHAND, book);
            hinty.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
            world.m_7967_((Entity)hinty);
            return true;
        }
        return false;
    }

    @Nullable
    default public Mob createHintMonster(Level world) {
        return (Mob)((EntityType)TFEntities.KOBOLD.get()).m_20615_(world);
    }

    public record HintConfig(ItemStack hintItem, EntityType<? extends Mob> hintMob) {
        public static MapCodec<HintConfig> FLAT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("hint_item").forGetter(HintConfig::hintItem), (App)Registry.f_122826_.m_194605_().comapFlatMap(HintConfig::checkCastMob, entityType -> entityType).fieldOf("hint_mob").forGetter(HintConfig::hintMob)).apply((Applicative)instance, HintConfig::new));
        public static Codec<HintConfig> CODEC = FLAT_CODEC.codec();

        private static DataResult<EntityType<? extends Mob>> checkCastMob(EntityType<?> entityType) {
            if (!entityType.m_142225_().isAssignableFrom(Mob.class)) {
                return DataResult.error((String)("Configured Hint Entity " + entityType.m_147048_() + " does not have a `Mob` superclass!"));
            }
            return DataResult.success(entityType);
        }
    }
}

