/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.ArrayUtil;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;
import twilightforest.world.components.structures.lichtowerrevamp.SideTowerCover;

public final class SideTowerRoom
extends TwilightTemplateStructurePiece {
    private static final List<String> SMALL_ROOMS = ImmutableList.of((Object)"empty_small", (Object)"library_steps_small");
    private static final List<String> MEDIUM_ROOMS = ImmutableList.of((Object)"empty_medium", (Object)"stacked_library_elbow_medium");
    private static final List<String> LARGE_ROOMS = ImmutableList.of((Object)"empty_large", (Object)"illegal_blockstate_kitchen", (Object)"library_plus_large");
    private static final EnumMap<Rotation, BlockPos> OFFSETS = new EnumMap(Rotation.class);
    private final int squareDiameter;
    private final Rotation externalRotation;

    public SideTowerRoom(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.SIDE_TOWER_ROOM.get(), compoundTag, ctx, SideTowerRoom.readSettings(compoundTag));
        this.squareDiameter = compoundTag.m_128451_("square_diameter");
        this.externalRotation = ArrayUtil.wrapped(Rotation.values(), compoundTag.m_128451_("ext_rotation"));
    }

    private SideTowerRoom(StructureTemplateManager structureManager, Rotation roomRotation, Rotation exteriorRotation, String name, BlockPos startPosition, int squareDiameter) {
        this(structureManager, TwilightForestMod.prefix("lich_tower/side_tower_rooms/" + name), SideTowerRoom.makeSettings(roomRotation), startPosition.m_121955_((Vec3i)OFFSETS.get(roomRotation).m_142393_(squareDiameter - 1)).m_121955_((Vec3i)OFFSETS.get(exteriorRotation).m_142393_(1 - squareDiameter)), squareDiameter, exteriorRotation);
    }

    private SideTowerRoom(StructureTemplateManager structureManager, ResourceLocation templateLocation, StructurePlaceSettings placeSettings, BlockPos startPosition, int squareDiameter, Rotation externalRotation) {
        super((StructurePieceType)TFStructurePieceTypes.SIDE_TOWER_ROOM.get(), 0, structureManager, templateLocation, placeSettings, startPosition);
        this.squareDiameter = squareDiameter;
        this.externalRotation = externalRotation;
    }

    public static SideTowerRoom smallRoom(StructureTemplateManager structureManager, Rotation exteriorRotation, BlockPos startPosition, RandomSource random) {
        return new SideTowerRoom(structureManager, Rotation.m_221990_((RandomSource)random), exteriorRotation, "small/" + (String)Util.m_214621_(SMALL_ROOMS, (RandomSource)random), startPosition, 5);
    }

    public static SideTowerRoom mediumRoom(StructureTemplateManager structureManager, Rotation exteriorRotation, BlockPos startPosition, RandomSource random) {
        return new SideTowerRoom(structureManager, Rotation.m_221990_((RandomSource)random), exteriorRotation, "medium/" + (String)Util.m_214621_(MEDIUM_ROOMS, (RandomSource)random), startPosition, 7);
    }

    public static SideTowerRoom largeRoom(StructureTemplateManager structureManager, Rotation exteriorRotation, BlockPos startPosition, RandomSource random) {
        return new SideTowerRoom(structureManager, Rotation.m_221990_((RandomSource)random), exteriorRotation, "large/" + (String)Util.m_214621_(LARGE_ROOMS, (RandomSource)random), startPosition, 9);
    }

    public void m_214092_(StructurePiece parent, StructurePieceAccessor structureStart, RandomSource random) {
        super.m_214092_(parent, structureStart, random);
        BlockPos center = this.f_73383_.m_162394_();
        BlockPos offset = new BlockPos(-(this.squareDiameter - 1 >> 1), -4, (this.squareDiameter - 1 >> 1) + 1);
        this.placeCover(structureStart, center, offset, random, Rotation.COUNTERCLOCKWISE_90);
        this.placeCover(structureStart, center, offset, random, Rotation.NONE);
        this.placeCover(structureStart, center, offset, random, Rotation.CLOCKWISE_90);
    }

    private void placeCover(StructurePieceAccessor structureStart, BlockPos center, BlockPos offset, RandomSource random, Rotation rotation) {
        Rotation relativeRotation = this.externalRotation.m_55952_(rotation);
        BlockPos pos = center.m_121955_((Vec3i)offset.m_7954_(relativeRotation));
        switch (this.squareDiameter) {
            case 9: {
                SideTowerCover largeCover = SideTowerCover.largeCover(this.structureManager, relativeRotation, pos, random);
                largeCover.m_214092_((StructurePiece)this, structureStart, random);
                structureStart.m_142679_((StructurePiece)largeCover);
                break;
            }
            case 7: {
                SideTowerCover mediumCover = SideTowerCover.mediumCover(this.structureManager, relativeRotation, pos, random);
                mediumCover.m_214092_((StructurePiece)this, structureStart, random);
                structureStart.m_142679_((StructurePiece)mediumCover);
                break;
            }
            case 5: {
                SideTowerCover smallCover = SideTowerCover.smallCover(this.structureManager, relativeRotation, pos, random);
                smallCover.m_214092_((StructurePiece)this, structureStart, random);
                structureStart.m_142679_((StructurePiece)smallCover);
            }
        }
    }

    protected void m_213704_(String label, BlockPos pPos, ServerLevelAccessor pLevel, RandomSource pRandom, BoundingBox pSbb) {
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.m_183620_(ctx, structureTag);
        structureTag.m_128405_("square_diameter", this.squareDiameter);
        structureTag.m_128405_("ext_rotation", this.externalRotation.ordinal());
    }

    static {
        OFFSETS.put(Rotation.NONE, BlockPos.f_121853_);
        OFFSETS.put(Rotation.CLOCKWISE_90, new BlockPos(1, 0, 0));
        OFFSETS.put(Rotation.CLOCKWISE_180, new BlockPos(1, 0, 1));
        OFFSETS.put(Rotation.COUNTERCLOCKWISE_90, new BlockPos(0, 0, 1));
    }
}

