/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.loot.TFLootTables;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.util.VoxelBresenhamIterator;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFTreeFeature;

public class HollowTreeFeature
extends TFTreeFeature<TFTreeFeatureConfig> {
    private static final int LEAF_DUNGEON_CHANCE = 8;

    public HollowTreeFeature(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    public boolean generate(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, BiConsumer<BlockPos, BlockState> decorationPlacer, TFTreeFeatureConfig config) {
        int diameter = random.m_188503_(3) + 2;
        int height = random.m_188503_(64) + diameter * 4;
        if (world.m_151562_(pos.m_123342_()) || world.m_151562_(pos.m_123342_() + height + diameter)) {
            return false;
        }
        int crownRadius = diameter * 4 + 8;
        for (int dx = -crownRadius; dx <= crownRadius; ++dx) {
            for (int dz = -crownRadius; dz <= crownRadius; ++dz) {
                for (int dy = height - crownRadius; dy <= height + crownRadius; ++dy) {
                    Block whatsThere = world.m_8055_(pos.m_7918_(dx, dy, dz)).m_60734_();
                    if (whatsThere == Blocks.f_50016_ || whatsThere instanceof LeavesBlock) continue;
                    return false;
                }
            }
        }
        BlockState state = world.m_8055_(pos.m_7495_());
        if (!state.m_60734_().canSustainPlant(state, (BlockGetter)world, pos.m_7495_(), Direction.UP, (IPlantable)TFBlocks.HOLLOW_OAK_SAPLING.get())) {
            return false;
        }
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, 3, 2, 6, 0.75, 3, 5, 3, false, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, 1, 2, 8, 0.9, 3, 5, 3, false, config);
        this.buildTrunk((LevelAccessor)world, trunkPlacer, decorationPlacer, random, pos, diameter, height, config);
        int numFireflies = random.m_188503_(6 * diameter) + 5;
        for (int i = 0; i <= numFireflies; ++i) {
            int fHeight = (int)((double)height * random.m_188500_() * 0.9) + height / 10;
            double fAngle = random.m_188500_();
            this.addFirefly((LevelAccessor)world, pos, diameter, fHeight, fAngle);
        }
        int numCicadas = random.m_188503_(3 * diameter) + 5;
        for (int i = 0; i <= numCicadas; ++i) {
            int fHeight = (int)((double)height * random.m_188500_() * 0.9) + height / 10;
            double fAngle = random.m_188500_();
            this.addCicada((LevelAccessor)world, pos, diameter, fHeight, fAngle);
        }
        this.buildFullCrown(world, trunkPlacer, leavesPlacer, random, pos, diameter, height, config);
        int numBranches = random.m_188503_(3) + 3;
        for (int i = 0; i <= numBranches; ++i) {
            int branchHeight = (int)((double)height * random.m_188500_() * 0.9) + height / 10;
            double branchRotation = random.m_188500_();
            this.makeSmallBranch((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos, diameter, branchHeight, 4.0, branchRotation, 0.35, true, config);
        }
        return true;
    }

    protected void buildFullCrown(WorldGenLevel world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int diameter, int height, TFTreeFeatureConfig config) {
        int crownRadius = diameter * 4 + 3;
        int bvar = diameter + 2;
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height - crownRadius, 0, crownRadius, 0.35, bvar, bvar + 2, 2, true, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height - crownRadius / 2, 0, crownRadius, 0.28, bvar, bvar + 2, 1, true, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height, 0, crownRadius, 0.15, 2, 4, 2, true, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height, 0, crownRadius / 2, 0.05, bvar, bvar + 2, 1, true, config);
    }

    protected void buildBranchRing(WorldGenLevel world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int diameter, int branchHeight, int heightVar, int length, double tilt, int minBranches, int maxBranches, int size, boolean leafy, TFTreeFeatureConfig config) {
        int numBranches = random.m_188503_(maxBranches - minBranches) + minBranches;
        double branchRotation = 1.0 / (double)(numBranches + 1);
        double branchOffset = random.m_188500_();
        for (int i = 0; i <= numBranches; ++i) {
            int dHeight = heightVar > 0 ? branchHeight - heightVar + random.m_188503_(2 * heightVar) : branchHeight;
            if (size == 2) {
                this.makeLargeBranch(world, trunkPlacer, leavesPlacer, random, pos, diameter, dHeight, length - 2, (double)i * branchRotation + branchOffset, tilt, leafy, config);
                continue;
            }
            if (size == 1) {
                this.makeMedBranch((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos, diameter, dHeight, length - 1, (double)i * branchRotation + branchOffset, tilt, leafy, config);
                continue;
            }
            if (size == 3) {
                this.makeRoot((LevelAccessor)world, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, config);
                continue;
            }
            this.makeSmallBranch((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy, config);
        }
    }

    protected void buildTrunk(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> decoPlacer, RandomSource random, BlockPos pos, int diameter, int height, TFTreeFeatureConfig config) {
        int dy;
        int dz;
        int dx;
        int hollow = diameter >> 1;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = -4; dy < 0; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = Math.max(ax, az = Math.abs(dz)) + (Math.min(ax, az) >> 1);
                    if (dist > diameter) continue;
                    BlockPos dPos = pos.m_7918_(dx, dy, dz);
                    if (FeatureUtil.hasAirAround(world, dPos)) {
                        if (dist > hollow) {
                            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, dPos, config.trunkProvider);
                            continue;
                        }
                        FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, dPos, config.branchProvider);
                        continue;
                    }
                    FeaturePlacers.placeIfValidRootPos((LevelSimulatedReader)world, decoPlacer, random, dPos, config.rootsProvider);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = 0; dy <= height; ++dy) {
                    int az;
                    BlockPos dPos = pos.m_7918_(dx, dy, dz);
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist <= diameter && dist > hollow) {
                        FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, dPos, config.trunkProvider);
                    }
                    if (dist <= hollow) {
                        // empty if block
                    }
                    if (dist != hollow || dx != hollow) continue;
                    world.m_7731_(dPos, (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
        }
    }

    protected void makeMedBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        BlockPos src = FeatureLogic.translate(pos.m_6630_(branchHeight), diameter, angle, 0.5);
        this.makeMedBranch(world, trunkPlacer, leavesPlacer, random, src, length, angle, tilt, leafy, config);
    }

    protected void makeMedBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos src, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        BlockPos dest = FeatureLogic.translate(src, length, angle, tilt);
        FeaturePlacers.drawBresenhamBranch(world, trunkPlacer, random, src, dest, config.branchProvider);
        if (leafy) {
            FeaturePlacers.placeSpheroid((LevelSimulatedReader)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, random, dest, 2.5f, 2.5f, config.leavesProvider);
        }
        int numShoots = random.m_188503_(2) + 1;
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i <= numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = random.m_188500_() * 0.8 + 0.2;
            double tiltVar = random.m_188500_() * 0.75 + 0.15;
            BlockPos bsrc = FeatureLogic.translate(src, length * outVar, angle, tilt);
            double slength = length * 0.4;
            this.makeSmallBranch(world, trunkPlacer, leavesPlacer, random, bsrc, slength, angle + angleVar, tilt * tiltVar, leafy, config);
        }
    }

    protected void makeSmallBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos src, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        BlockPos dest = FeatureLogic.translate(src, length, angle, tilt);
        FeaturePlacers.drawBresenhamBranch(world, trunkPlacer, random, src, dest, config.branchProvider);
        if (leafy) {
            float leafRad = (float)random.m_188503_(2) + 1.5f;
            FeaturePlacers.placeSpheroid((LevelSimulatedReader)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, random, dest, leafRad, leafRad, config.leavesProvider);
        }
    }

    protected void makeSmallBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        BlockPos src = FeatureLogic.translate(pos.m_6630_(branchHeight), diameter, angle, 0.5);
        this.makeSmallBranch(world, trunkPlacer, leavesPlacer, random, src, length, angle, tilt, leafy, config);
    }

    protected void makeRoot(LevelAccessor worldReader, RandomSource random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, TFTreeFeatureConfig config) {
        BlockPos src = FeatureLogic.translate(pos.m_6630_(branchHeight), diameter, angle, 0.5);
        BlockPos dest = FeatureLogic.translate(src, length, angle, tilt);
        FeaturePlacers.traceExposedRoot((LevelSimulatedReader)worldReader, (checkedPos, state) -> worldReader.m_7731_(checkedPos, state, 3), random, config.branchProvider, config.rootsProvider, new VoxelBresenhamIterator(src, dest));
    }

    protected void makeLargeBranch(WorldGenLevel world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos src, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        BlockPos dest = FeatureLogic.translate(src, length, angle, tilt);
        FeaturePlacers.drawBresenhamBranch((LevelAccessor)world, trunkPlacer, random, src, dest, config.branchProvider);
        int reinforcements = random.m_188503_(3);
        for (int i = 0; i <= reinforcements; ++i) {
            int vx = (i & 2) == 0 ? 1 : 0;
            int vy = (i & 1) == 0 ? 1 : -1;
            int vz = (i & 2) == 0 ? 0 : 1;
            FeaturePlacers.drawBresenhamBranch((LevelAccessor)world, trunkPlacer, random, src.m_7918_(vx, vy, vz), dest, config.branchProvider);
        }
        if (leafy) {
            FeaturePlacers.placeSpheroid((LevelSimulatedReader)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, random, dest.m_7494_(), 3.5f, 3.5f, config.leavesProvider);
        }
        int numMedBranches = random.m_188503_((int)(length / 6.0)) + random.m_188503_(2) + 1;
        for (int i = 0; i <= numMedBranches; ++i) {
            double outVar = random.m_188500_() * 0.3 + 0.3;
            double angleVar = random.m_188500_() * 0.225 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = FeatureLogic.translate(src, length * outVar, angle, tilt);
            this.makeMedBranch((LevelAccessor)world, trunkPlacer, leavesPlacer, random, bsrc, length * 0.6, angle + angleVar, tilt, leafy, config);
        }
        int numSmallBranches = random.m_188503_(2) + 1;
        for (int i = 0; i <= numSmallBranches; ++i) {
            double outVar = random.m_188500_() * 0.25 + 0.25;
            double angleVar = random.m_188500_() * 0.25 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = FeatureLogic.translate(src, length * outVar, angle, tilt);
            this.makeSmallBranch((LevelAccessor)world, trunkPlacer, leavesPlacer, random, bsrc, Math.max(length * 0.3, 2.0), angle + angleVar, tilt, leafy, config);
        }
        if (random.m_188503_(8) == 0) {
            this.makeLeafDungeon(world, leavesPlacer, random, dest.m_7494_(), config);
        }
    }

    private void makeLeafDungeon(WorldGenLevel world, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, TFTreeFeatureConfig config) {
        FeaturePlacers.placeSpheroid((LevelSimulatedReader)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, random, pos, 4.5f, 4.5f, config.leavesProvider);
        FeatureUtil.drawBlob((LevelAccessor)world, pos, 3, config.branchProvider.m_213972_(random, pos));
        FeatureUtil.drawBlob((LevelAccessor)world, pos, 2, Blocks.f_50016_.m_49966_());
        world.m_7731_(pos.m_7494_(), Blocks.f_50085_.m_49966_(), 18);
        SpawnerBlockEntity ms = (SpawnerBlockEntity)world.m_7702_(pos.m_7494_());
        if (ms != null) {
            ms.m_59801_().m_45462_((EntityType)TFEntities.SWARM_SPIDER.get());
        }
        this.makeLeafDungeonChest(world, random, pos);
    }

    private void makeLeafDungeonChest(WorldGenLevel world, RandomSource random, BlockPos pos) {
        Direction chestDir = Direction.Plane.HORIZONTAL.m_235690_(random);
        pos = pos.m_5484_(chestDir, 2);
        TFLootTables.TREE_CACHE.generateChest(world, pos.m_7495_(), chestDir.m_122424_(), false);
    }

    protected void makeLargeBranch(WorldGenLevel world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        BlockPos src = FeatureLogic.translate(pos.m_6630_(branchHeight), diameter, angle, 0.5);
        this.makeLargeBranch(world, trunkPlacer, leavesPlacer, random, src, length, angle, tilt, leafy, config);
    }

    protected void addFirefly(LevelAccessor world, BlockPos pos, int diameter, int fHeight, double fAngle) {
        BlockPos src = FeatureLogic.translate(pos.m_6630_(fHeight), diameter + 1, fAngle, 0.5);
        Direction facing = Direction.EAST;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            facing = Direction.SOUTH;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            facing = Direction.EAST;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            facing = Direction.NORTH;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            facing = Direction.WEST;
        }
        if (((BlockState)((Block)TFBlocks.FIREFLY.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)facing)).m_60710_((LevelReader)world, src)) {
            world.m_7731_(src, (BlockState)((Block)TFBlocks.FIREFLY.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)facing), 3);
        }
    }

    protected void addCicada(LevelAccessor world, BlockPos pos, int diameter, int fHeight, double fAngle) {
        BlockPos src = FeatureLogic.translate(pos.m_6630_(fHeight), diameter + 1, fAngle, 0.5);
        Direction facing = Direction.EAST;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            facing = Direction.SOUTH;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            facing = Direction.EAST;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            facing = Direction.NORTH;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            facing = Direction.WEST;
        }
        if (((BlockState)((Block)TFBlocks.CICADA.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)facing)).m_60710_((LevelReader)world, src)) {
            world.m_7731_(src, (BlockState)((Block)TFBlocks.CICADA.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)facing), 3);
        }
    }
}

