/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFTreeFeature;

public class CanopyTreeFeature
extends TFTreeFeature<TFTreeFeatureConfig> {
    private final List<BlockPos> leaves = Lists.newArrayList();

    public CanopyTreeFeature(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, BiConsumer<BlockPos, BlockState> decorationPlacer, TFTreeFeatureConfig config) {
        int treeHeight = config.minHeight;
        if (random.m_188503_(config.chanceAddFiveFirst) == 0) {
            treeHeight += random.m_188503_(5);
            if (random.m_188503_(config.chanceAddFiveSecond) == 0) {
                treeHeight += random.m_188503_(5);
            }
        }
        if (world.m_151562_(pos.m_123342_() + treeHeight)) {
            return false;
        }
        BlockState state = world.m_8055_(pos.m_7495_());
        if (!state.m_60734_().canSustainPlant(state, (BlockGetter)world, pos.m_7495_(), Direction.UP, (IPlantable)TFBlocks.CANOPY_SAPLING.get())) {
            return false;
        }
        this.leaves.clear();
        this.buildBranch((LevelAccessor)world, pos, trunkPlacer, 0, treeHeight, 0.0, 0.0, true, random, config);
        int numBranches = 3 + random.m_188503_(2);
        float offset = random.m_188501_();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch((LevelAccessor)world, pos, trunkPlacer, treeHeight - 10 + b, 9.0, 0.3 * (double)b + (double)offset, 0.2, false, random, config);
        }
        if (config.hasLeaves) {
            for (BlockPos leafPos : this.leaves) {
                this.makeLeafBlob((LevelSimulatedReader)world, leavesPlacer, random, leafPos, config);
            }
        }
        if (FeatureUtil.hasAirAround((LevelAccessor)world, pos.m_7495_())) {
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, pos.m_7495_(), config.trunkProvider);
        } else {
            FeaturePlacers.placeIfValidRootPos((LevelSimulatedReader)world, decorationPlacer, random, pos.m_7495_(), config.rootsProvider);
        }
        int numRoots = 3 + random.m_188503_(2);
        offset = random.m_188501_();
        for (int b = 0; b < numRoots; ++b) {
            FeaturePlacers.buildRoot((LevelAccessor)world, decorationPlacer, random, pos, offset, b, config.rootsProvider);
        }
        return true;
    }

    private void makeLeafBlob(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> leafPlacer, RandomSource random, BlockPos leafPos, TFTreeFeatureConfig config) {
        FeaturePlacers.placeCircleOdd(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, random, leafPos.m_7495_(), 3.0f, config.leavesProvider);
        FeaturePlacers.placeCircleOdd(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, random, leafPos, 4.0f, config.leavesProvider);
        FeaturePlacers.placeCircleOdd(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, random, leafPos.m_7494_(), 2.0f, config.leavesProvider);
    }

    void buildBranch(LevelAccessor world, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, int height, double length, double angle, double tilt, boolean trunk, RandomSource treeRNG, TFTreeFeatureConfig config) {
        BlockPos src = pos.m_6630_(height);
        BlockPos dest = FeatureLogic.translate(src, length, angle, tilt);
        if (world.isAreaLoaded(dest, 5)) {
            if (trunk) {
                FeaturePlacers.drawBresenhamTree((LevelSimulatedReader)world, trunkPlacer, FeaturePlacers.VALID_TREE_POS, src, dest, config.trunkProvider, treeRNG);
            } else {
                FeaturePlacers.drawBresenhamBranch(world, trunkPlacer, treeRNG, src, dest, config.branchProvider);
            }
            if (trunk) {
                FeaturePlacers.addFirefly(world, pos, 3 + treeRNG.m_188503_(7), treeRNG.m_188500_());
            }
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, treeRNG, dest.m_122029_(), config.branchProvider);
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, treeRNG, dest.m_122024_(), config.branchProvider);
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, treeRNG, dest.m_122019_(), config.branchProvider);
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, treeRNG, dest.m_122012_(), config.branchProvider);
            this.leaves.add(dest);
        }
    }
}

