/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.biomesources;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.Float2ObjectSortedMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;
import twilightforest.util.Codecs;

public record SpecialBiomePalette(Holder<Biome> river, Climate.ParameterList<Holder<Biome>> regularBiomes, HolderSet<Biome> specialBiomes, List<Float2ObjectSortedMap<Holder<Biome>>> landmarkGradients, List<Holder<Biome>> allBiomes) {
    public static final Codec<SpecialBiomePalette> CODEC = (Codec)Util.m_137537_(() -> {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Biome.f_47431_.fieldOf("river").forGetter(SpecialBiomePalette::river), (App)Codecs.CLIMATE_SYSTEM.fieldOf("common").forGetter(SpecialBiomePalette::regularBiomes), (App)Biome.f_47432_.fieldOf("special").forGetter(SpecialBiomePalette::specialBiomes), (App)Codecs.floatTreeCodec(Biome.f_47431_).listOf().comapFlatMap(l -> Util.m_143795_((List)l, (int)4), Function.identity()).fieldOf("landmarks").forGetter(SpecialBiomePalette::landmarkGradients)).apply((Applicative)instance, SpecialBiomePalette::create));
        return codec.orElseGet(SpecialBiomePalette::create);
    });
    private static final int[][] BINARY_GRID_PERMUTATIONS = new int[][]{{0, 1, 2, 3}, {0, 1, 3, 2}, {0, 2, 1, 3}, {0, 2, 3, 1}, {0, 3, 1, 2}, {0, 3, 2, 1}, {1, 0, 2, 3}, {1, 0, 3, 2}, {1, 2, 0, 3}, {1, 2, 3, 0}, {1, 3, 0, 2}, {1, 3, 2, 0}, {2, 0, 1, 3}, {2, 0, 3, 1}, {2, 1, 0, 3}, {2, 1, 3, 0}, {2, 3, 0, 1}, {2, 3, 1, 0}, {3, 0, 1, 2}, {3, 0, 2, 1}, {3, 1, 0, 2}, {3, 1, 2, 0}, {3, 2, 0, 1}, {3, 2, 1, 0}};

    private static SpecialBiomePalette create() {
        return SpecialBiomePalette.create((Holder<Biome>)Holder.m_205709_((Object)OverworldBiomes.m_194913_()), (Climate.ParameterList<Holder<Biome>>)new Climate.ParameterList(Collections.emptyList()), (HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[0]), Collections.emptyList());
    }

    private static SpecialBiomePalette create(Holder<Biome> river, Climate.ParameterList<Holder<Biome>> common, HolderSet<Biome> rare, List<Float2ObjectSortedMap<Holder<Biome>>> clusters) {
        return new SpecialBiomePalette(river, common, rare, clusters, (List<Holder<Biome>>)ImmutableList.builder().add(river).addAll(common.m_186850_().stream().map(Pair::getSecond).iterator()).addAll(rare).addAll(clusters.stream().flatMap(tree -> tree.float2ObjectEntrySet().stream()).map(Map.Entry::getValue).iterator()).build());
    }

    @Nullable
    public Holder<Biome> getNearestLandmark(float distanceRelative, int landmarkIndex, long permutation) {
        if (distanceRelative > 1.0f) {
            return null;
        }
        return (Holder)this.getNearestLandmark(landmarkIndex, permutation).get(distanceRelative);
    }

    private Float2ObjectSortedMap<Holder<Biome>> getNearestLandmark(int landmarkIndex, long permutation) {
        return this.landmarkGradients().get(BINARY_GRID_PERMUTATIONS[(int)(permutation % 24L)][landmarkIndex]);
    }
}

