/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import twilightforest.block.GiantBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.giant_pick.GiantPickMineCapability;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;

@Mod.EventBusSubscriber(modid="twilightforest")
public class GiantToolGroupingModifier
extends LootModifier {
    public static final Codec<GiantToolGroupingModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GiantToolGroupingModifier::new));
    private static boolean isBreakingWithGiantPick = false;
    private static boolean shouldMakeGiantCobble = false;
    private static int amountOfCobbleToReplace = 0;

    public GiantToolGroupingModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList<ItemStack> newLoot = new ObjectArrayList<ItemStack>();
        boolean flag = false;
        if (shouldMakeGiantCobble && generatedLoot.size() > 0 && ((ItemStack)generatedLoot.get(0)).m_41720_() == Item.m_41439_((Block)Blocks.f_50652_)) {
            generatedLoot.remove(0);
            if (amountOfCobbleToReplace == 64) {
                newLoot.add((Object)new ItemStack((ItemLike)TFBlocks.GIANT_COBBLESTONE.get()));
                flag = true;
            }
            if (--amountOfCobbleToReplace <= 0) {
                shouldMakeGiantCobble = false;
            }
        }
        return flag ? newLoot : generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (!isBreakingWithGiantPick && GiantToolGroupingModifier.canHarvestWithGiantPick(player, state)) {
            boolean allCobble;
            isBreakingWithGiantPick = true;
            Item cobbleItem = Blocks.f_50652_.m_5456_();
            boolean bl = allCobble = state.m_60734_().m_5456_() == cobbleItem;
            if (allCobble) {
                for (BlockPos dPos : GiantBlock.getVolume(pos)) {
                    BlockState stateThere;
                    if (dPos.equals((Object)pos) || (stateThere = event.getLevel().m_8055_(dPos)).m_60734_().m_5456_() == cobbleItem) continue;
                    allCobble = false;
                    break;
                }
            }
            if (allCobble && !player.m_150110_().f_35937_) {
                shouldMakeGiantCobble = true;
                amountOfCobbleToReplace = 64;
            } else {
                shouldMakeGiantCobble = false;
                amountOfCobbleToReplace = 0;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer playerMP = (ServerPlayer)player;
                for (BlockPos dPos : GiantBlock.getVolume(pos)) {
                    if (dPos.equals((Object)pos) || state.m_60734_() != event.getLevel().m_8055_(dPos).m_60734_()) continue;
                    playerMP.f_8941_.m_9280_(dPos);
                }
            }
            isBreakingWithGiantPick = false;
        }
    }

    private static boolean canHarvestWithGiantPick(Player player, BlockState state) {
        return player.m_21205_().m_150930_((Item)TFItems.GIANT_PICKAXE.get()) && ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) && player.getCapability(CapabilityList.GIANT_PICK_MINE).map(GiantPickMineCapability::getMining).orElse(1L).longValue() == player.f_19853_.m_46467_();
    }
}

