/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFSounds;
import twilightforest.util.VoxelBresenhamIterator;

@Mod.EventBusSubscriber(modid="twilightforest")
public class OreMagnetItem
extends Item {
    private static final float WIGGLE = 10.0f;
    private static boolean cacheNeedsBuild = true;
    private static final HashMap<Block, Block> ORE_TO_BLOCK_REPLACEMENTS = new HashMap();

    public OreMagnetItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        AtomicBoolean badEnchant = new AtomicBoolean();
        EnchantmentHelper.m_44831_((ItemStack)book).forEach((enchantment, integer) -> {
            if (!Objects.equals(Enchantments.f_44986_, enchantment)) {
                badEnchant.set(true);
            }
        });
        return !badEnchant.get() && super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @Nonnull InteractionHand hand) {
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int useRemaining) {
        int useTime = this.m_8105_(stack) - useRemaining;
        if (!level.m_5776_() && useTime > 10) {
            int moved = this.doMagnet(level, living, 0.0f, 0.0f);
            if (moved == 0) {
                moved = this.doMagnet(level, living, 10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(level, living, 10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(level, living, 0.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(level, living, -10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(level, living, -10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(level, living, -10.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(level, living, 0.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(level, living, 10.0f, -10.0f);
            }
            if (moved > 0) {
                stack.m_41622_(moved, living, user -> user.m_21190_(living.m_7655_()));
                level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), (SoundEvent)TFSounds.MAGNET_GRAB.get(), living.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    private int doMagnet(Level level, LivingEntity living, float yawOffset, float pitchOffset) {
        double range = 32.0;
        Vec3 srcVec = new Vec3(living.m_20185_(), living.m_20186_() + (double)living.m_20192_(), living.m_20189_());
        Vec3 lookVec = this.getOffsetLook(living, yawOffset, pitchOffset);
        Vec3 destVec = srcVec.m_82520_(lookVec.m_7096_() * range, lookVec.m_7098_() * range, lookVec.m_7094_() * range);
        return OreMagnetItem.doMagnet(level, new BlockPos(srcVec), new BlockPos(destVec));
    }

    public static int doMagnet(Level level, BlockPos usePos, BlockPos destPos) {
        OreMagnetItem.initOre2BlockMap();
        int blocksMoved = 0;
        BlockState attactedOreBlock = Blocks.f_50016_.m_49966_();
        BlockState replacementBlock = Blocks.f_50016_.m_49966_();
        BlockPos foundPos = null;
        BlockPos basePos = null;
        for (BlockPos coord : new VoxelBresenhamIterator(usePos, destPos)) {
            BlockState searchState = level.m_8055_(coord);
            if (basePos == null) {
                if (!OreMagnetItem.isReplaceable(searchState)) continue;
                basePos = coord;
                continue;
            }
            if (foundPos != null || searchState.m_60734_() == Blocks.f_50016_ || !OreMagnetItem.isOre(searchState.m_60734_()) || level.m_7702_(coord) != null) continue;
            attactedOreBlock = searchState;
            replacementBlock = ORE_TO_BLOCK_REPLACEMENTS.getOrDefault(attactedOreBlock.m_60734_(), Blocks.f_50069_).m_49966_();
            foundPos = coord;
        }
        if (basePos != null && foundPos != null && attactedOreBlock.m_60734_() != Blocks.f_50016_) {
            HashSet<BlockPos> veinBlocks = new HashSet<BlockPos>();
            OreMagnetItem.findVein(level, foundPos, attactedOreBlock, veinBlocks);
            int offX = basePos.m_123341_() - foundPos.m_123341_();
            int offY = basePos.m_123342_() - foundPos.m_123342_();
            int offZ = basePos.m_123343_() - foundPos.m_123343_();
            for (BlockPos coord : veinBlocks) {
                BlockPos replacePos = coord.m_7918_(offX, offY, offZ);
                BlockState replaceState = level.m_8055_(replacePos);
                if (!OreMagnetItem.isReplaceable(replaceState) && !replaceState.m_60767_().m_76336_() && !replaceState.m_60795_()) continue;
                level.m_7731_(coord, replacementBlock, 2);
                level.m_7731_(replacePos, attactedOreBlock, 2);
                ++blocksMoved;
            }
        }
        return blocksMoved;
    }

    private Vec3 getOffsetLook(LivingEntity living, float yawOffset, float pitchOffset) {
        float var2 = Mth.m_14089_((float)(-(living.m_146908_() + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var3 = Mth.m_14031_((float)(-(living.m_146908_() + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var4 = -Mth.m_14089_((float)(-(living.m_146909_() + pitchOffset) * ((float)Math.PI / 180)));
        float var5 = Mth.m_14031_((float)(-(living.m_146909_() + pitchOffset) * ((float)Math.PI / 180)));
        return new Vec3((double)(var3 * var4), (double)var5, (double)(var2 * var4));
    }

    @Deprecated
    private static boolean isReplaceable(BlockState state) {
        return state.m_204336_(BlockTagGenerator.ORE_MAGNET_SAFE_REPLACE_BLOCK);
    }

    private static boolean findVein(Level level, BlockPos here, BlockState oreState, Set<BlockPos> veinBlocks) {
        if (veinBlocks.contains(here)) {
            return false;
        }
        if (veinBlocks.size() >= 24) {
            return false;
        }
        if (level.m_8055_(here) == oreState) {
            veinBlocks.add(here);
            for (Direction e : Direction.values()) {
                OreMagnetItem.findVein(level, here.m_121945_(e), oreState, veinBlocks);
            }
            return true;
        }
        return false;
    }

    private static boolean isOre(Block ore) {
        return ORE_TO_BLOCK_REPLACEMENTS.containsKey(ore);
    }

    private static void initOre2BlockMap() {
        if (!cacheNeedsBuild) {
            return;
        }
        TwilightForestMod.LOGGER.info("GENERATING ORE TO BLOCK MAPPING");
        for (TagKey tag : Registry.f_122824_.m_203613_().filter(location -> location.f_203868_().m_135827_().equals("forge")).collect(Collectors.toList())) {
            if (!tag.f_203868_().m_135815_().contains("ores_in_ground/")) continue;
            String oreground = tag.f_203868_().m_135815_().substring(15);
            if (!Registry.f_122824_.m_203613_().filter(location -> location.f_203868_().m_135827_().equals("forge")).anyMatch(blockTagKey -> blockTagKey.f_203868_().m_135815_().equals("ore_bearing_ground/" + oreground))) continue;
            ((HolderSet.Named)Objects.requireNonNull(Registry.f_122824_.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("forge", "ore_bearing_ground/" + oreground)))).get()).forEach(groundHolder -> ((HolderSet.Named)Objects.requireNonNull(Registry.f_122824_.m_203431_(tag)).get()).forEach(oreHolder -> {
                if (!oreHolder.m_203656_(BlockTagGenerator.ORE_MAGNET_IGNORE)) {
                    ORE_TO_BLOCK_REPLACEMENTS.put((Block)oreHolder.m_203334_(), (Block)groundHolder.m_203334_());
                }
            }));
        }
        cacheNeedsBuild = false;
    }

    @SubscribeEvent
    public static void buildOreMagnetCache(AddReloadListenerEvent event) {
        event.addListener((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> {
            if (!cacheNeedsBuild) {
                ORE_TO_BLOCK_REPLACEMENTS.clear();
                cacheNeedsBuild = true;
            }
            return stage.m_6769_(null).thenRun(() -> {});
        });
    }
}

