/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.helpers;

import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.TwilightForestMod;
import twilightforest.block.BanisterBlock;
import twilightforest.enums.BanisterShape;

public abstract class BlockModelHelpers
extends BlockStateProvider {
    protected static final ResourceLocation SOLID = new ResourceLocation("solid");
    protected static final ResourceLocation CUTOUT = new ResourceLocation("cutout");
    protected static final ResourceLocation CUTOUT_MIPPED = new ResourceLocation("cutout_mipped");
    protected static final ResourceLocation TRANSLUCENT = new ResourceLocation("translucent");

    public BlockModelHelpers(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "twilightforest", exFileHelper);
    }

    protected void builtinEntity(Block b, String particle) {
        this.simpleBlock(b, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(b))).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).texture("particle", particle));
    }

    protected void simpleBlockExisting(Block b) {
        this.simpleBlock(b, new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(TwilightForestMod.prefix(this.name(b))))});
    }

    public void simpleBlockWithRenderType(Block block, ResourceLocation type) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block))).renderType(type));
    }

    protected void singleBlockBoilerPlate(Block b, String parent, Consumer<BlockModelBuilder> modelCustomizer) {
        BlockModelBuilder bModel = (BlockModelBuilder)this.models().withExistingParent(this.name(b), parent);
        modelCustomizer.accept(bModel);
        this.simpleBlock(b, (ModelFile)bModel);
    }

    protected void logWoodSapling(RotatedPillarBlock log, RotatedPillarBlock slog, RotatedPillarBlock wood, RotatedPillarBlock swood, Block sapling) {
        this.logBlock(log);
        this.logBlock(slog);
        ResourceLocation sideTex = this.blockTexture((Block)log);
        this.axisBlock(wood, sideTex, sideTex);
        ResourceLocation sSideTex = this.blockTexture((Block)slog);
        this.axisBlock(swood, sSideTex, sSideTex);
        ResourceLocation saplingTex = TwilightForestMod.prefix("block/" + this.name(sapling));
        this.simpleBlock(sapling, (ModelFile)((BlockModelBuilder)this.models().cross(this.name(sapling), saplingTex)).renderType(CUTOUT));
    }

    protected void plankBlocks(String variant, Block plank, Block slab, StairBlock stair, Block button, Block fence, Block gate, Block plate, DoorBlock door, TrapDoorBlock trapdoor, BanisterBlock banister) {
        this.plankBlocks(variant, plank, slab, stair, button, fence, gate, plate, door, trapdoor, false, banister);
    }

    protected void plankBlocks(String variant, Block plank, Block slab, StairBlock stair, Block button, Block fence, Block gate, Block plate, DoorBlock door, TrapDoorBlock trapdoor, boolean cutoutDoors, BanisterBlock banister) {
        String plankTexName = "planks_" + variant;
        String plankDir = "block/wood/planks/" + variant + "/";
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_3");
        ConfiguredModel[] plankModels = ConfiguredModel.builder().weight(10).modelFile((ModelFile)this.models().cubeAll(plankDir + this.name(plank), tex0)).nextModel().weight(10).modelFile((ModelFile)this.models().cubeAll(plankDir + this.name(plank) + "_1", tex1)).nextModel().weight(1).modelFile((ModelFile)this.models().cubeAll(plankDir + this.name(plank) + "_2", tex2)).nextModel().weight(1).modelFile((ModelFile)this.models().cubeAll(plankDir + this.name(plank) + "_3", tex3)).build();
        this.simpleBlock(plank, plankModels);
        String slabDir = "block/wood/slab/" + variant + "/";
        ConfiguredModel[] bottomSlabModels = ConfiguredModel.builder().weight(10).modelFile((ModelFile)this.models().slab(slabDir + this.name(slab), tex0, tex0, tex0)).nextModel().weight(10).modelFile((ModelFile)this.models().slab(slabDir + this.name(slab) + "_1", tex1, tex1, tex1)).nextModel().weight(1).modelFile((ModelFile)this.models().slab(slabDir + this.name(slab) + "_2", tex2, tex2, tex2)).nextModel().weight(1).modelFile((ModelFile)this.models().slab(slabDir + this.name(slab) + "_3", tex3, tex3, tex3)).build();
        ConfiguredModel[] topSlabModels = ConfiguredModel.builder().weight(10).uvLock(true).rotationX(180).modelFile(bottomSlabModels[0].model).nextModel().weight(10).uvLock(true).rotationX(180).modelFile(bottomSlabModels[1].model).nextModel().weight(1).uvLock(true).rotationX(180).modelFile(bottomSlabModels[2].model).nextModel().weight(1).uvLock(true).rotationX(180).modelFile(bottomSlabModels[3].model).build();
        this.getVariantBuilder(slab).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).setModels(bottomSlabModels);
        this.getVariantBuilder(slab).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).setModels(topSlabModels);
        this.getVariantBuilder(slab).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).setModels(plankModels);
        this.woodStairs(stair, plankTexName, variant);
        this.woodButton(button, plankTexName, variant);
        this.woodFence(fence, plankTexName, variant);
        this.woodGate(gate, plankTexName, variant);
        this.woodPlate(plate, plankTexName, variant);
        String doorDir = "block/wood/door/" + variant + "/";
        String trapdoorDir = "block/wood/trapdoor/" + variant + "/";
        if (cutoutDoors) {
            this.doorBlockWithRenderType(door, doorDir + this.name((Block)door), TwilightForestMod.prefix("block/wood/door/" + variant + "_lower"), TwilightForestMod.prefix("block/wood/door/" + variant + "_upper"), CUTOUT);
            this.trapdoorBlockWithRenderType(trapdoor, trapdoorDir + variant, TwilightForestMod.prefix("block/wood/trapdoor/" + variant + "_trapdoor"), true, CUTOUT);
        } else {
            this.doorBlock(door, doorDir + this.name((Block)door), TwilightForestMod.prefix("block/wood/door/" + variant + "_lower"), TwilightForestMod.prefix("block/wood/door/" + variant + "_upper"));
            this.trapdoorBlock(trapdoor, trapdoorDir + variant, TwilightForestMod.prefix("block/wood/trapdoor/" + variant + "_trapdoor"), true);
        }
        this.banister(banister, plankTexName, variant);
    }

    protected void woodGate(Block gate, String texName, String variant) {
        String gateDir = "block/wood/fence_gate/" + variant + "/";
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder gate0 = this.models().fenceGate(gateDir + this.name(gate), tex0);
        ModelBuilder gate1 = this.models().fenceGate(gateDir + this.name(gate) + "_1", tex1);
        ModelBuilder gate2 = this.models().fenceGate(gateDir + this.name(gate) + "_2", tex2);
        ModelBuilder gate3 = this.models().fenceGate(gateDir + this.name(gate) + "_3", tex3);
        ModelBuilder open0 = this.models().fenceGateOpen(gateDir + this.name(gate) + "_open", tex0);
        ModelBuilder open1 = this.models().fenceGateOpen(gateDir + this.name(gate) + "_open_1", tex1);
        ModelBuilder open2 = this.models().fenceGateOpen(gateDir + this.name(gate) + "_open_2", tex2);
        ModelBuilder open3 = this.models().fenceGateOpen(gateDir + this.name(gate) + "_open_3", tex3);
        ModelBuilder wall0 = this.models().fenceGateWall(gateDir + this.name(gate) + "_wall", tex0);
        ModelBuilder wall1 = this.models().fenceGateWall(gateDir + this.name(gate) + "_wall_1", tex1);
        ModelBuilder wall2 = this.models().fenceGateWall(gateDir + this.name(gate) + "_wall_2", tex2);
        ModelBuilder wall3 = this.models().fenceGateWall(gateDir + this.name(gate) + "_wall_3", tex3);
        ModelBuilder wallOpen0 = this.models().fenceGateWallOpen(gateDir + this.name(gate) + "_wall_open", tex0);
        ModelBuilder wallOpen1 = this.models().fenceGateWallOpen(gateDir + this.name(gate) + "_wall_open_1", tex1);
        ModelBuilder wallOpen2 = this.models().fenceGateWallOpen(gateDir + this.name(gate) + "_wall_open_2", tex2);
        ModelBuilder wallOpen3 = this.models().fenceGateWallOpen(gateDir + this.name(gate) + "_wall_open_3", tex3);
        this.getVariantBuilder(gate).forAllStatesExcept(arg_0 -> BlockModelHelpers.lambda$woodGate$0((ModelFile)gate0, (ModelFile)gate1, (ModelFile)gate2, (ModelFile)gate3, (ModelFile)wall0, (ModelFile)wall1, (ModelFile)wall2, (ModelFile)wall3, (ModelFile)wallOpen0, (ModelFile)open0, (ModelFile)wallOpen1, (ModelFile)open1, (ModelFile)wallOpen2, (ModelFile)open2, (ModelFile)wallOpen3, (ModelFile)open3, arg_0), new Property[]{FenceGateBlock.f_53342_});
    }

    protected void woodFence(Block fence, String texName, String variant) {
        String fenceDir = "block/wood/fence/" + variant + "/";
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder post0 = this.models().fencePost(fenceDir + this.name(fence) + "_post", tex0);
        ModelBuilder post1 = this.models().fencePost(fenceDir + this.name(fence) + "_post_1", tex1);
        ModelBuilder post2 = this.models().fencePost(fenceDir + this.name(fence) + "_post_2", tex2);
        ModelBuilder post3 = this.models().fencePost(fenceDir + this.name(fence) + "_post_3", tex3);
        ModelBuilder side0 = this.models().fenceSide(fenceDir + this.name(fence) + "_side", tex0);
        ModelBuilder side1 = this.models().fenceSide(fenceDir + this.name(fence) + "_side_1", tex1);
        ModelBuilder side2 = this.models().fenceSide(fenceDir + this.name(fence) + "_side_2", tex2);
        ModelBuilder side3 = this.models().fenceSide(fenceDir + this.name(fence) + "_side_3", tex3);
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(fence).part().weight(10).modelFile((ModelFile)post0).nextModel().weight(10).modelFile((ModelFile)post1).nextModel().weight(1).modelFile((ModelFile)post2).nextModel().weight(1).modelFile((ModelFile)post3).addModel()).end();
        PipeBlock.f_55154_.forEach((arg_0, arg_1) -> BlockModelHelpers.lambda$woodFence$1(builder, (ModelFile)side0, (ModelFile)side1, (ModelFile)side2, (ModelFile)side3, arg_0, arg_1));
    }

    protected void woodPlate(Block plate, String texName, String variant) {
        String plateDir = "block/wood/pressure_plate/" + variant + "/";
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ConfiguredModel[] unpressed = ConfiguredModel.builder().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate), "pressure_plate_up")).texture("texture", tex0)).nextModel().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_1", "pressure_plate_up")).texture("texture", tex1)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_2", "pressure_plate_up")).texture("texture", tex2)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_3", "pressure_plate_up")).texture("texture", tex3)).build();
        ConfiguredModel[] pressed = ConfiguredModel.builder().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_down", "pressure_plate_down")).texture("texture", tex0)).nextModel().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_down_1", "pressure_plate_down")).texture("texture", tex1)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_down_2", "pressure_plate_down")).texture("texture", tex2)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_down_3", "pressure_plate_down")).texture("texture", tex3)).build();
        this.getVariantBuilder(plate).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(false)).setModels(unpressed);
        this.getVariantBuilder(plate).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(true)).setModels(pressed);
    }

    protected void woodButton(Block button, String texName, String variant) {
        String buttonDir = "block/wood/button/" + variant + "/";
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder unpressed0 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button), "button")).texture("texture", tex0);
        ModelBuilder pressed0 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_pressed", "button_pressed")).texture("texture", tex0);
        ModelBuilder unpressed1 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_1", "button")).texture("texture", tex1);
        ModelBuilder pressed1 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_pressed_1", "button_pressed")).texture("texture", tex1);
        ModelBuilder unpressed2 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_2", "button")).texture("texture", tex2);
        ModelBuilder pressed2 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_pressed_2", "button_pressed")).texture("texture", tex2);
        ModelBuilder unpressed3 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_3", "button")).texture("texture", tex3);
        ModelBuilder pressed3 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_pressed_3", "button_pressed")).texture("texture", tex3);
        this.getVariantBuilder(button).forAllStates(arg_0 -> BlockModelHelpers.lambda$woodButton$2((ModelFile)pressed0, (ModelFile)unpressed0, (ModelFile)pressed1, (ModelFile)unpressed1, (ModelFile)pressed2, (ModelFile)unpressed2, (ModelFile)pressed3, (ModelFile)unpressed3, arg_0));
    }

    protected void woodStairs(StairBlock block, String texName, String variant) {
        String stairsDir = "block/wood/stairs/" + variant + "/";
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder main0 = this.models().stairs(stairsDir + this.name((Block)block), tex0, tex0, tex0);
        ModelBuilder main1 = this.models().stairs(stairsDir + this.name((Block)block) + "_1", tex1, tex1, tex1);
        ModelBuilder main2 = this.models().stairs(stairsDir + this.name((Block)block) + "_2", tex2, tex2, tex2);
        ModelBuilder main3 = this.models().stairs(stairsDir + this.name((Block)block) + "_3", tex3, tex3, tex3);
        ModelBuilder inner0 = this.models().stairsInner(stairsDir + this.name((Block)block) + "_inner", tex0, tex0, tex0);
        ModelBuilder inner1 = this.models().stairsInner(stairsDir + this.name((Block)block) + "_inner_1", tex1, tex1, tex1);
        ModelBuilder inner2 = this.models().stairsInner(stairsDir + this.name((Block)block) + "_inner_2", tex2, tex2, tex2);
        ModelBuilder inner3 = this.models().stairsInner(stairsDir + this.name((Block)block) + "_inner_3", tex3, tex3, tex3);
        ModelBuilder outer0 = this.models().stairsOuter(stairsDir + this.name((Block)block) + "_outer", tex0, tex0, tex0);
        ModelBuilder outer1 = this.models().stairsOuter(stairsDir + this.name((Block)block) + "_outer_1", tex1, tex1, tex1);
        ModelBuilder outer2 = this.models().stairsOuter(stairsDir + this.name((Block)block) + "_outer_2", tex2, tex2, tex2);
        ModelBuilder outer3 = this.models().stairsOuter(stairsDir + this.name((Block)block) + "_outer_3", tex3, tex3, tex3);
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> BlockModelHelpers.lambda$woodStairs$3((ModelFile)main0, (ModelFile)inner0, (ModelFile)outer0, (ModelFile)main1, (ModelFile)inner1, (ModelFile)outer1, (ModelFile)main2, (ModelFile)inner2, (ModelFile)outer2, (ModelFile)main3, (ModelFile)inner3, (ModelFile)outer3, arg_0), new Property[]{StairBlock.f_56844_});
    }

    protected void banister(BanisterBlock banister, String texName, String woodVariant) {
        String banisterDir = "block/wood/banister/" + woodVariant + "/";
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        this.getVariantBuilder((Block)banister).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)BanisterBlock.f_54117_);
            int yRot = (int)facing.m_122435_();
            String extended = (Boolean)state.m_61143_((Property)BanisterBlock.EXTENDED) != false ? "_extended" : "";
            String variant = ((BanisterShape)((Object)((Object)state.m_61143_(BanisterBlock.SHAPE)))).m_7912_() + extended;
            String newModelName = banisterDir + this.name((Block)banister) + "_" + variant;
            return ConfiguredModel.builder().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(newModelName, TwilightForestMod.prefix("banister_" + variant))).texture("texture", tex0)).rotationY(yRot).nextModel().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(newModelName + "_1", TwilightForestMod.prefix("banister_" + variant))).texture("texture", tex1)).rotationY(yRot).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(newModelName + "_2", TwilightForestMod.prefix("banister_" + variant))).texture("texture", tex2)).rotationY(yRot).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(newModelName + "_3", TwilightForestMod.prefix("banister_" + variant))).texture("texture", tex3)).rotationY(yRot).build();
        }, new Property[]{BanisterBlock.WATERLOGGED});
    }

    protected void banisterVanilla(BanisterBlock banister, String texName, String woodVariant) {
        String banisterDir = "block/wood/banister/" + woodVariant + "/";
        ResourceLocation tex0 = new ResourceLocation("block/" + texName);
        this.getVariantBuilder((Block)banister).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)BanisterBlock.f_54117_);
            int yRot = (int)facing.m_122435_();
            String extended = (Boolean)state.m_61143_((Property)BanisterBlock.EXTENDED) != false ? "_extended" : "";
            String variant = ((BanisterShape)((Object)((Object)state.m_61143_(BanisterBlock.SHAPE)))).m_7912_() + extended;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(banisterDir + this.name((Block)banister) + "_" + variant, TwilightForestMod.prefix("banister_" + variant))).texture("texture", tex0)).rotationY(yRot).build();
        }, new Property[]{BanisterBlock.WATERLOGGED});
    }

    protected void bisectedStairsBlock(RegistryObject<StairBlock> block, ResourceLocation side, ResourceLocation end, ResourceLocation middle) {
        this.bisectedStairsBlock(block, block.getId().m_135815_(), side, end, middle);
    }

    protected void bisectedStairsBlock(RegistryObject<StairBlock> block, String name, ResourceLocation side, ResourceLocation end, ResourceLocation middle) {
        ModelBuilder stairs = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, TwilightForestMod.prefix("block/util/bisected_stairs"))).texture("side", side)).texture("end", end)).texture("middle", middle);
        ModelBuilder stairsInner = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_inner", TwilightForestMod.prefix("block/util/bisected_inner_stairs"))).texture("side", side)).texture("end", end)).texture("middle", middle);
        ModelBuilder stairsOuter = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_outer", TwilightForestMod.prefix("block/util/bisected_outer_stairs"))).texture("side", side)).texture("end", end)).texture("middle", middle);
        this.stairsBlock((StairBlock)block.get(), (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    protected ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    protected String name(Block block) {
        return this.key(block).m_135815_();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodStairs$3(ModelFile main0, ModelFile inner0, ModelFile outer0, ModelFile main1, ModelFile inner1, ModelFile outer1, ModelFile main2, ModelFile inner2, ModelFile outer2, ModelFile main3, ModelFile inner3, ModelFile outer3, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        int yRot = (int)facing.m_122427_().m_122435_();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
            yRot += 270;
        }
        if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
            yRot += 90;
        }
        boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
        return ConfiguredModel.builder().weight(10).modelFile(shape == StairsShape.STRAIGHT ? main0 : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner0 : outer0)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).nextModel().weight(10).modelFile(shape == StairsShape.STRAIGHT ? main1 : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner1 : outer1)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).nextModel().weight(1).modelFile(shape == StairsShape.STRAIGHT ? main2 : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner2 : outer2)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).nextModel().weight(1).modelFile(shape == StairsShape.STRAIGHT ? main3 : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner3 : outer3)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodButton$2(ModelFile pressed0, ModelFile unpressed0, ModelFile pressed1, ModelFile unpressed1, ModelFile pressed2, ModelFile unpressed2, ModelFile pressed3, ModelFile unpressed3, BlockState state) {
        ModelFile model0 = (Boolean)state.m_61143_((Property)ButtonBlock.f_51045_) != false ? pressed0 : unpressed0;
        ModelFile model1 = (Boolean)state.m_61143_((Property)ButtonBlock.f_51045_) != false ? pressed1 : unpressed1;
        ModelFile model2 = (Boolean)state.m_61143_((Property)ButtonBlock.f_51045_) != false ? pressed2 : unpressed2;
        ModelFile model3 = (Boolean)state.m_61143_((Property)ButtonBlock.f_51045_) != false ? pressed3 : unpressed3;
        int rotX = switch ((AttachFace)state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.WALL -> 90;
            case AttachFace.FLOOR -> 0;
            case AttachFace.CEILING -> 180;
        };
        int rotY = 0;
        if (state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_) == AttachFace.CEILING) {
            switch ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
                case NORTH: {
                    rotY = 180;
                    break;
                }
                case WEST: {
                    rotY = 90;
                    break;
                }
                case EAST: {
                    rotY = 270;
                }
            }
        } else {
            switch ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
                case SOUTH: {
                    rotY = 180;
                    break;
                }
                case WEST: {
                    rotY = 270;
                    break;
                }
                case EAST: {
                    rotY = 90;
                }
            }
        }
        boolean uvlock = state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_) == AttachFace.WALL;
        return ConfiguredModel.builder().weight(10).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model0).nextModel().weight(10).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model1).nextModel().weight(1).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model2).nextModel().weight(1).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model3).build();
    }

    private static /* synthetic */ void lambda$woodFence$1(MultiPartBlockStateBuilder builder, ModelFile side0, ModelFile side1, ModelFile side2, ModelFile side3, Direction dir, BooleanProperty value) {
        if (dir.m_122434_().m_122479_()) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().weight(10).modelFile(side0).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).nextModel().weight(10).modelFile(side1).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).nextModel().weight(1).modelFile(side2).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).nextModel().weight(1).modelFile(side3).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).addModel()).condition((Property)value, (Comparable[])new Boolean[]{true});
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodGate$0(ModelFile gate0, ModelFile gate1, ModelFile gate2, ModelFile gate3, ModelFile wall0, ModelFile wall1, ModelFile wall2, ModelFile wall3, ModelFile wallOpen0, ModelFile open0, ModelFile wallOpen1, ModelFile open1, ModelFile wallOpen2, ModelFile open2, ModelFile wallOpen3, ModelFile open3, BlockState state) {
        ModelFile model0 = gate0;
        ModelFile model1 = gate1;
        ModelFile model2 = gate2;
        ModelFile model3 = gate3;
        if (((Boolean)state.m_61143_((Property)FenceGateBlock.f_53343_)).booleanValue()) {
            model0 = wall0;
            model1 = wall1;
            model2 = wall2;
            model3 = wall3;
        }
        if (((Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
            model0 = model0 == wall0 ? wallOpen0 : open0;
            model1 = model1 == wall1 ? wallOpen1 : open1;
            model2 = model2 == wall2 ? wallOpen2 : open2;
            model3 = model3 == wall3 ? wallOpen3 : open3;
        }
        return ConfiguredModel.builder().weight(10).modelFile(model0).rotationY((int)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_()).uvLock(true).nextModel().weight(10).modelFile(model1).rotationY((int)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_()).uvLock(true).nextModel().weight(1).modelFile(model2).rotationY((int)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_()).uvLock(true).nextModel().weight(1).modelFile(model3).rotationY((int)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_()).uvLock(true).build();
    }
}

