/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.ChainModel;
import twilightforest.client.model.entity.SpikeBlockModel;
import twilightforest.entity.ChainBlock;

public class BlockChainRenderer
extends EntityRenderer<ChainBlock> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("blockgoblin.png");
    private final Model model;
    private final Model chainModel;

    public BlockChainRenderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.model = new SpikeBlockModel(manager.m_174023_(TFModelLayers.CHAIN_BLOCK));
        this.chainModel = new ChainModel(manager.m_174023_(TFModelLayers.CHAIN));
    }

    public void render(ChainBlock chainBlock, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        super.m_7392_((Entity)chainBlock, yaw, partialTicks, stack, buffer, light);
        stack.m_85836_();
        VertexConsumer ivertexbuilder = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)this.model.m_103119_(textureLoc), (boolean)false, (boolean)chainBlock.isFoil());
        float pitch = chainBlock.f_19860_ + (chainBlock.m_146909_() - chainBlock.f_19860_) * partialTicks;
        stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - Mth.m_14177_((float)yaw)));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.m_7695_(stack, ivertexbuilder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
        BlockChainRenderer.renderChain((Entity)chainBlock, (Entity)chainBlock.chain1, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain((Entity)chainBlock, (Entity)chainBlock.chain2, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain((Entity)chainBlock, (Entity)chainBlock.chain3, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain((Entity)chainBlock, (Entity)chainBlock.chain4, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain((Entity)chainBlock, (Entity)chainBlock.chain5, yaw, partialTicks, stack, buffer, light, this.chainModel);
    }

    public static void renderChain(Entity parent, Entity chain, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, Model chainModel) {
        VertexConsumer vertexConsumer;
        double chainInX = Mth.m_14139_((double)partialTicks, (double)chain.f_19790_, (double)chain.m_20185_()) - Mth.m_14139_((double)partialTicks, (double)parent.f_19790_, (double)parent.m_20185_());
        double chainInY = Mth.m_14139_((double)partialTicks, (double)chain.f_19791_, (double)chain.m_20186_()) - Mth.m_14139_((double)partialTicks, (double)parent.f_19791_, (double)parent.m_20186_());
        double chainInZ = Mth.m_14139_((double)partialTicks, (double)chain.f_19792_, (double)chain.m_20189_()) - Mth.m_14139_((double)partialTicks, (double)parent.f_19792_, (double)parent.m_20189_());
        stack.m_85836_();
        if (parent instanceof ChainBlock) {
            ChainBlock blocc = (ChainBlock)parent;
            vertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)chainModel.m_103119_(textureLoc), (boolean)false, (boolean)blocc.isFoil());
        } else {
            vertexConsumer = buffer.m_6299_(chainModel.m_103119_(textureLoc));
        }
        stack.m_85837_(chainInX, chainInY, chainInZ);
        float pitch = chain.f_19860_ + (chain.m_146909_() - chain.f_19860_) * partialTicks;
        stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - Mth.m_14177_((float)yaw)));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        chainModel.m_7695_(stack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    private void renderMultiBoundingBox(PoseStack stack, VertexConsumer builder, Entity entity, float red, float grean, float blue) {
        AABB axisalignedbb = entity.m_20191_().m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
        LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)axisalignedbb, (float)red, (float)grean, (float)blue, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(ChainBlock entity) {
        return textureLoc;
    }
}

