/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block.giantblock;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twilightforest.util.Vec2i;

public class GiantBlockModel
implements IDynamicBakedModel {
    private static final ModelProperty<GiantBlockData> DATA = new ModelProperty();
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private final TextureAtlasSprite[] textures;
    private final TextureAtlasSprite particle;
    private final ItemOverrides overrides;
    private final ItemTransforms transforms;
    private final ChunkRenderTypeSet blockRenderTypes;
    private final List<RenderType> itemRenderTypes;
    private final List<RenderType> fabulousItemRenderTypes;

    public GiantBlockModel(TextureAtlasSprite[] texture, TextureAtlasSprite particle, ItemOverrides overrides, ItemTransforms transforms, RenderTypeGroup group) {
        this.textures = texture;
        this.particle = particle;
        this.overrides = overrides;
        this.transforms = transforms;
        this.blockRenderTypes = !group.isEmpty() ? ChunkRenderTypeSet.of((RenderType[])new RenderType[]{group.block()}) : null;
        this.itemRenderTypes = !group.isEmpty() ? List.of(group.entity()) : null;
        this.fabulousItemRenderTypes = !group.isEmpty() ? List.of(group.entityFabulous()) : null;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (extraData.has(DATA) && side != null) {
            BlockPos pos = ((GiantBlockData)extraData.get(DATA)).pos();
            Vec2i coords = this.calculateOffset(side, pos.m_121955_((Vec3i)this.magicOffsetFromDir(side)));
            TextureAtlasSprite sprite = this.textures[this.textures.length > 1 ? side.ordinal() : 0];
            quads.add(FACE_BAKERY.m_111600_(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), new BlockElementFace(side, side.ordinal(), side.name(), new BlockFaceUV(new float[]{0.0f + (float)coords.x, 0.0f + (float)coords.z, 4.0f + (float)coords.x, 4.0f + (float)coords.z}, 0)), sprite, side, (ModelState)BlockModelRotation.X0_Y0, null, false, new ResourceLocation(sprite.m_118413_().m_135827_(), sprite.m_118413_().m_135815_() + "_" + side.name().toLowerCase(Locale.ROOT))));
        }
        return quads;
    }

    private BlockPos magicOffsetFromDir(Direction side) {
        return switch (side) {
            default -> new BlockPos(0, 0, -1);
            case Direction.DOWN -> new BlockPos(0, 0, 2);
            case Direction.NORTH, Direction.SOUTH -> new BlockPos(0, 1, 0);
            case Direction.WEST, Direction.EAST -> new BlockPos(0, 1, -1);
        };
    }

    private Vec2i calculateOffset(Direction side, BlockPos pos) {
        int offsetY;
        int offsetX;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (side.m_122434_().m_122478_()) {
            offsetX = x % 4;
            offsetY = (side.m_122430_() * z + 1) % 4;
        } else if (side.m_122434_() == Direction.Axis.Z) {
            offsetX = x % 4;
            offsetY = -y % 4;
        } else {
            offsetX = (z + 1) % 4;
            offsetY = -y % 4;
        }
        if (side == Direction.NORTH || side == Direction.EAST) {
            offsetX = (4 - offsetX - 1) % 4;
        }
        if (offsetX < 0) {
            offsetX += 16;
        }
        if (offsetY < 0) {
            offsetY += 16;
        }
        return new Vec2i(offsetX % 4 * 4, offsetY % 4 * 4);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        if (modelData == ModelData.EMPTY) {
            modelData = ModelData.builder().with(DATA, (Object)new GiantBlockData(level, pos)).build();
        }
        return modelData;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particle;
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return this.transforms;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.blockRenderTypes != null ? this.blockRenderTypes : super.getRenderTypes(state, rand, data);
    }

    @NotNull
    public List<RenderType> getRenderTypes(@NotNull ItemStack stack, boolean fabulous) {
        if (!fabulous) {
            if (this.itemRenderTypes != null) {
                return this.itemRenderTypes;
            }
        } else if (this.fabulousItemRenderTypes != null) {
            return this.fabulousItemRenderTypes;
        }
        return super.getRenderTypes(stack, fabulous);
    }

    public record GiantBlockData(BlockAndTintGetter getter, BlockPos pos) {
    }
}

