/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.TFConfig;
import twilightforest.block.SpecialMagicLogBlock;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFSounds;
import twilightforest.util.WorldUtil;

public class TimeLogCoreBlock
extends SpecialMagicLogBlock {
    public TimeLogCoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean doesCoreFunction() {
        return (Boolean)TFConfig.COMMON_CONFIG.MAGIC_TREES.disableTime.get() == false;
    }

    @Override
    void performTreeEffect(Level level, BlockPos pos, RandomSource rand) {
        int numticks = 24 * this.tickRate();
        for (int i = 0; i < numticks; ++i) {
            BlockEntityTicker ticker;
            BlockEntity entity;
            BlockPos dPos = WorldUtil.randomOffset(rand, pos, (Integer)TFConfig.COMMON_CONFIG.MAGIC_TREES.miningRange.get());
            BlockState state = level.m_8055_(dPos);
            if (state.m_204336_(BlockTagGenerator.TIME_CORE_EXCLUDED)) continue;
            if (state.m_60823_()) {
                state.m_222972_((ServerLevel)level, dPos, rand);
            }
            if ((entity = level.m_7702_(dPos)) == null || (ticker = state.m_155944_(level, entity.m_58903_())) == null) continue;
            ticker.m_155252_(level, dPos, state, entity);
        }
    }

    @Override
    protected void playSound(Level level, BlockPos pos, RandomSource rand) {
        level.m_5594_(null, pos, (SoundEvent)TFSounds.TIME_CORE.get(), SoundSource.BLOCKS, 0.35f, 0.5f);
    }
}

