/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;

public class CastleDoorBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty VANISHED = BooleanProperty.m_61465_((String)"vanish");
    private static final VoxelShape REAPPEARING_BB = Shapes.m_83064_((AABB)new AABB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625));

    public CastleDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VANISHED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE, VANISHED});
    }

    public boolean m_6104_(BlockState state, BlockState otherState, Direction direction) {
        return otherState.m_60734_() instanceof CastleDoorBlock && otherState.m_61143_((Property)VANISHED) == state.m_61143_((Property)VANISHED);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)VANISHED) != false || (Boolean)state.m_61143_((Property)ACTIVE) == false ? Shapes.m_83040_() : super.m_7952_(state, getter, pos);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)VANISHED) != false ? Shapes.m_83040_() : super.m_5939_(state, getter, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)VANISHED) != false ? REAPPEARING_BB : super.m_5940_(state, getter, pos, context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.onActivation(level, pos, state);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!(block instanceof CastleDoorBlock) && level.m_46753_(pos)) {
            this.onActivation(level, pos, state);
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    private InteractionResult onActivation(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)VANISHED)).booleanValue() || ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (CastleDoorBlock.isBlockLocked(level, pos)) {
            level.m_5594_(null, pos, (SoundEvent)TFSounds.DOOR_ACTIVATED.get(), SoundSource.BLOCKS, 1.0f, 0.3f);
            return InteractionResult.PASS;
        }
        this.changeToActiveBlock(level, pos, state);
        return InteractionResult.SUCCESS;
    }

    private void changeToActiveBlock(Level level, BlockPos pos, BlockState originState) {
        if (originState.m_60734_() instanceof CastleDoorBlock) {
            level.m_46597_(pos, (BlockState)originState.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
        }
        level.m_186460_(pos, originState.m_60734_(), 2 + level.m_213780_().m_188503_(5));
    }

    private static boolean isBlockLocked(Level level, BlockPos pos) {
        if (!level.m_5776_()) {
            ChunkGeneratorTwilight chunkGeneratorTwilight = WorldUtil.getChunkGenerator((LevelAccessor)level);
        }
        return false;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)VANISHED)).booleanValue()) {
            if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)VANISHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            } else {
                this.changeToActiveBlock((Level)level, pos, state);
            }
            this.playReappearSound((Level)level, pos);
        } else if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)VANISHED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            level.m_186460_(pos, (Block)this, 80);
            this.playVanishSound((Level)level, pos);
            this.vanishParticles((Level)level, pos);
            for (Direction e : Direction.values()) {
                this.checkAndActivateCastleDoor((Level)level, pos.m_121945_(e));
            }
        }
    }

    private void playVanishSound(Level level, BlockPos pos) {
        level.m_5594_(null, pos, (SoundEvent)TFSounds.DOOR_VANISH.get(), SoundSource.BLOCKS, 0.125f, level.m_213780_().m_188501_() * 0.25f + 1.75f);
    }

    private void playReappearSound(Level level, BlockPos pos) {
        level.m_5594_(null, pos, (SoundEvent)TFSounds.DOOR_REAPPEAR.get(), SoundSource.BLOCKS, 0.125f, level.m_213780_().m_188501_() * 0.25f + 1.25f);
    }

    public void checkAndActivateCastleDoor(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof CastleDoorBlock && !((Boolean)state.m_61143_((Property)VANISHED)).booleanValue() && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && !CastleDoorBlock.isBlockLocked(level, pos)) {
            this.changeToActiveBlock(level, pos, state);
        }
    }

    private void vanishParticles(Level level, BlockPos pos) {
        RandomSource rand = level.m_213780_();
        if (level instanceof ServerLevel) {
            for (int dx = 0; dx < 4; ++dx) {
                for (int dy = 0; dy < 4; ++dy) {
                    for (int dz = 0; dz < 4; ++dz) {
                        double x = (double)pos.m_123341_() + ((double)dx + 0.5) / 4.0;
                        double y = (double)pos.m_123342_() + ((double)dy + 0.5) / 4.0;
                        double z = (double)pos.m_123343_() + ((double)dz + 0.5) / 4.0;
                        double speed = rand.m_188583_() * 0.2;
                        ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TFParticleType.ANNIHILATE.get()), x, y, z, 1, 0.0, 0.0, 0.0, speed);
                    }
                }
            }
        }
    }
}

