/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.network.messages;

import java.util.function.BiConsumer;
import me.codexadrian.tempad.data.LocationData;
import me.codexadrian.tempad.data.TempadComponent;
import me.codexadrian.tempad.network.handlers.IPacket;
import me.codexadrian.tempad.network.handlers.IPacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record AddLocationPacket(String name, InteractionHand hand) implements IPacket<AddLocationPacket>
{
    public static Handler HANDLER = new Handler();
    public static final ResourceLocation ID = new ResourceLocation("tempad", "location");

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public IPacketHandler<AddLocationPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements IPacketHandler<AddLocationPacket> {
        private Handler() {
        }

        @Override
        public void encode(AddLocationPacket message, FriendlyByteBuf buffer) {
            buffer.m_130070_(message.name);
            buffer.m_130068_((Enum)message.hand);
        }

        @Override
        public AddLocationPacket decode(FriendlyByteBuf buffer) {
            return new AddLocationPacket(buffer.m_130277_(), (InteractionHand)buffer.m_130066_(InteractionHand.class));
        }

        @Override
        public BiConsumer<MinecraftServer, Player> handle(AddLocationPacket message) {
            return (server, player) -> {
                ItemStack stack = player.m_21120_(message.hand);
                LocationData tempadLocation = new LocationData(message.name, (ResourceKey<Level>)player.f_19853_.m_46472_(), new BlockPos(player.m_20185_(), Math.ceil(player.m_20186_()), player.m_20189_()));
                TempadComponent.addStackLocation(stack, tempadLocation);
            };
        }
    }
}

