/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.api.util.IScrollableItem;
import com.ldtteam.structurize.api.util.ISpecialBlockPickItem;
import com.ldtteam.structurize.network.messages.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMiddleMouseMessage
implements IMessage {
    @Nullable
    private final BlockPos pos;
    private final double delta;
    private final boolean ctrlKey;

    public ItemMiddleMouseMessage(@Nullable BlockPos pos, boolean ctrlKey) {
        this.pos = pos;
        this.delta = 0.0;
        this.ctrlKey = ctrlKey;
    }

    public ItemMiddleMouseMessage(double delta, boolean ctrlKey) {
        this.pos = null;
        this.delta = delta;
        this.ctrlKey = ctrlKey;
    }

    public ItemMiddleMouseMessage(@NotNull FriendlyByteBuf buf) {
        this.pos = buf.readBoolean() ? buf.m_130135_() : null;
        this.delta = buf.readDouble();
        this.ctrlKey = buf.readBoolean();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        if (this.pos == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130064_(this.pos);
        }
        buf.writeDouble(this.delta);
        buf.writeBoolean(this.ctrlKey);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(@NotNull NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        ItemStack current = player.m_150109_().m_36056_();
        if (this.delta == 0.0) {
            Item item = current.m_41720_();
            if (item instanceof ISpecialBlockPickItem) {
                ISpecialBlockPickItem clickableItem = (ISpecialBlockPickItem)item;
                clickableItem.onBlockPick((Player)player, current, this.pos, this.ctrlKey);
            }
        } else {
            Item item = current.m_41720_();
            if (item instanceof IScrollableItem) {
                IScrollableItem scrollableItem = (IScrollableItem)item;
                scrollableItem.onMouseScroll((Player)player, current, this.delta, this.ctrlKey);
            }
        }
    }
}

