/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.compat.jei;

import java.util.List;
import me.codexadrian.spirit.compat.jei.categories.PedestalRecipeCategory;
import me.codexadrian.spirit.compat.jei.categories.SoulCageCategory;
import me.codexadrian.spirit.compat.jei.categories.SoulEngulfingCategory;
import me.codexadrian.spirit.compat.jei.ingredients.EntityIngredient;
import me.codexadrian.spirit.compat.jei.ingredients.EntityIngredientHelper;
import me.codexadrian.spirit.compat.jei.ingredients.EntityRenderer;
import me.codexadrian.spirit.registry.SpiritBlocks;
import me.codexadrian.spirit.registry.SpiritMisc;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class SpiritPlugin
implements IModPlugin {
    public static final IIngredientType<EntityIngredient> ENTITY_INGREDIENT = () -> EntityIngredient.class;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("spirit", "jei");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        super.registerRecipes(registration);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            registration.addRecipes(PedestalRecipeCategory.RECIPE, level.m_7465_().m_44013_(SpiritMisc.SOUL_TRANSMUTATION_RECIPE.get()));
            registration.addRecipes(SoulCageCategory.RECIPE, level.m_7465_().m_44013_(SpiritMisc.TIER_RECIPE.get()));
            registration.addRecipes(SoulEngulfingCategory.RECIPE, SoulEngulfingCategory.getRecipes(level.m_7465_().m_44013_(SpiritMisc.SOUL_ENGULFING_RECIPE.get())));
        }
    }

    public void registerIngredients(@NotNull IModIngredientRegistration registration) {
        registration.register(ENTITY_INGREDIENT, List.of(), (IIngredientHelper)new EntityIngredientHelper(), (IIngredientRenderer)new EntityRenderer());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(SpiritBlocks.SOUL_PEDESTAL.get().m_5456_().m_7968_(), new RecipeType[]{PedestalRecipeCategory.RECIPE});
        registration.addRecipeCatalyst(SpiritBlocks.PEDESTAL.get().m_5456_().m_7968_(), new RecipeType[]{PedestalRecipeCategory.RECIPE});
        registration.addRecipeCatalyst(SpiritBlocks.SOUL_CAGE.get().m_5456_().m_7968_(), new RecipeType[]{SoulCageCategory.RECIPE});
        registration.addRecipeCatalyst(Blocks.f_50135_.m_5456_().m_7968_(), new RecipeType[]{SoulEngulfingCategory.RECIPE});
        registration.addRecipeCatalyst(Items.f_42409_.m_7968_(), new RecipeType[]{SoulEngulfingCategory.RECIPE});
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        super.registerCategories(registration);
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new PedestalRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SoulCageCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SoulEngulfingCategory(guiHelper)});
    }
}

