/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.silentchaos512.lib.util.MCMathUtils;

public abstract class LockableSidedInventoryTileEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    protected NonNullList<ItemStack> items;
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected LockableSidedInventoryTileEntity(BlockEntityType<?> typeIn, int inventorySize, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.items = NonNullList.m_122780_((int)inventorySize, (Object)ItemStack.f_41583_);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && MCMathUtils.distanceSq((Entity)player, (Vec3i)this.f_58858_) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tags, this.items);
    }

    public void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        ContainerHelper.m_18973_((CompoundTag)tags, this.items);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, be -> {
            CompoundTag tags = this.m_5995_();
            ContainerHelper.m_18973_((CompoundTag)tags, this.items);
            return tags;
        });
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        ContainerHelper.m_18980_((CompoundTag)packet.m_131708_(), this.items);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (side == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

