/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.silentchaos512.gear.api.ApiConst;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.utils.MathUtils;

public class SelfRepairTrait
extends SimpleTrait {
    public static final ITraitSerializer<SelfRepairTrait> SERIALIZER = new SimpleTrait.Serializer<SelfRepairTrait>(ApiConst.SELF_REPAIR_TRAIT_ID, SelfRepairTrait::new, (trait, json) -> {
        trait.activationChance = GsonHelper.m_13915_((JsonObject)json, (String)"activation_chance");
        trait.repairAmount = GsonHelper.m_13824_((JsonObject)json, (String)"repair_amount", (int)1);
    }, (trait, buffer) -> {
        trait.activationChance = buffer.readFloat();
        trait.repairAmount = buffer.m_130242_();
    }, (trait, buffer) -> {
        buffer.writeFloat(trait.activationChance);
        buffer.m_130130_(trait.repairAmount);
    });
    private float activationChance;
    private int repairAmount;

    public SelfRepairTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
        if (this.shouldActivate(context)) {
            int amount = -this.repairAmount * context.getTraitLevel();
            GearHelper.attemptDamage(context.getGear(), amount, (LivingEntity)context.getPlayer(), InteractionHand.MAIN_HAND);
        }
    }

    private boolean shouldActivate(TraitActionContext context) {
        if (context.getPlayer() != null && context.getPlayer().f_19797_ % 20 == 0) {
            return MathUtils.tryPercentage((double)(this.activationChance * (float)context.getTraitLevel()));
        }
        return false;
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        float chancePercent = 100.0f * this.activationChance;
        ret.add(String.format("  - %.1f%% chance per level of %s %d durability each second", Float.valueOf(chancePercent), this.repairAmount > 0 ? "restoring" : "losing", Math.abs(this.repairAmount)));
        ret.add("  - Only works if equipped or in a player's inventory");
        return ret;
    }
}

