/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.ModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.data.client.CompoundModelBuilder;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.util.NameUtils;

public class CompoundModelsProvider
extends ModelProvider<ItemModelBuilder> {
    public CompoundModelsProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "silentgear", "item", CompoundModelBuilder::new, existingFileHelper);
    }

    public String m_6055_() {
        return "Silent Gear - Compound Item Models";
    }

    protected void registerModels() {
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(this.mcLoc("item/generated"));
        ModelFile.ExistingModelFile itemHandheld = this.getExistingFile(this.mcLoc("item/handheld"));
    }

    protected CompoundModelBuilder gearBuilder(ICoreItem item) {
        return ((CompoundModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).m_135815_())).setLoader(Const.GEAR_MODEL_LOADER).setGearType(item.getGearType());
    }

    protected CompoundModelBuilder partBuilder(CompoundPartItem item) {
        CompoundModelBuilder builder = ((CompoundModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).m_135815_())).setLoader(Const.COMPOUND_PART_MODEL_LOADER).setGearType(item.getGearType()).setPartType(item.getPartType());
        if (item.getGearType().isArmor() && item.getGearType() != GearType.ELYTRA) {
            builder.setTexturePath("part/armor");
            if (item.getGearType().matches(GearType.HELMET)) {
                builder.addExtraLayer(SilentGear.getId("blueprint_helmet"));
            }
            if (item.getGearType().matches(GearType.CHESTPLATE)) {
                builder.addExtraLayer(SilentGear.getId("blueprint_chestplate"));
            }
            if (item.getGearType().matches(GearType.LEGGINGS)) {
                builder.addExtraLayer(SilentGear.getId("blueprint_leggings"));
            }
            if (item.getGearType().matches(GearType.BOOTS)) {
                builder.addExtraLayer(SilentGear.getId("blueprint_boots"));
            }
        }
        return builder;
    }

    private CompoundModelBuilder fragmentBuilder(FragmentItem item) {
        return ((CompoundModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).m_135815_())).setLoader(Const.FRAGMENT_MODEL_LOADER).setGearType(GearType.FRAGMENT).setPartType(PartType.MAIN);
    }
}

