/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.util.GearData;

public final class PartsCommand {
    private static final SuggestionProvider<CommandSourceStack> partIdSuggestions = (ctx, builder) -> SharedSuggestionProvider.m_82957_(PartManager.getValues().stream().map(IGearPart::getId), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> partInGearSuggestions = (ctx, builder) -> {
        PartDataList parts = GearData.getConstructionParts(PartsCommand.getGear((CommandContext<CommandSourceStack>)ctx));
        return SharedSuggestionProvider.m_82957_(parts.getUniqueParts(false).stream().map(part -> part.get().getId()), (SuggestionsBuilder)builder);
    };
    private static final Pattern FORMAT_CODES = Pattern.compile("\u00a7[0-9a-z]");

    private PartsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"sgear_parts");
        builder.then(Commands.m_82127_((String)"list").executes(PartsCommand::runList));
        builder.then(Commands.m_82127_((String)"dump").executes(PartsCommand::runDump));
        dispatcher.register(builder);
    }

    private static int runList(CommandContext<CommandSourceStack> context) {
        String listStr = PartManager.getValues().stream().map(part -> part.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)listStr), true);
        for (PartType type : PartType.getValues()) {
            int count = PartManager.getPartsOfType(type).size();
            String str = String.format("%s: %d", type.getName(), count);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)str), true);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runDump(CommandContext<CommandSourceStack> context) {
        String dirPath = "output/silentgear";
        String fileName = "part_export.tsv";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Could not create directory: " + output.getParent())));
            return 0;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            StringBuilder builder = new StringBuilder("Name\tID\tType\tTier\t");
            ItemStats.allStatsOrdered().forEach(s -> builder.append(s.getDisplayName().getString()).append("\t"));
            builder.append("Traits");
            writer.write(builder.toString());
            for (IGearPart part : PartManager.getValues()) {
                writer.write(PartsCommand.partToTsvLine(part) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Wrote to " + output.getAbsolutePath())), true);
        }
        return 1;
    }

    private static String partToTsvLine(IGearPart part) {
        StringBuilder builder = new StringBuilder();
        PartData partData = PartData.of(part);
        PartsCommand.appendTsv(builder, part.getDisplayName(partData, ItemStack.f_41583_).getString());
        PartsCommand.appendTsv(builder, part.getId().toString());
        PartsCommand.appendTsv(builder, part.getType().getName());
        PartsCommand.appendTsv(builder, partData.getTier());
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            Collection<StatInstance> statModifiers = partData.getStatModifiers(StatGearKey.of(stat, GearType.ALL), ItemStack.f_41583_);
            PartsCommand.appendTsv(builder, FORMAT_CODES.matcher(StatModifierMap.formatText(statModifiers, stat, 5).getString()).replaceAll(""));
        }
        PartsCommand.appendTsv(builder, partData.getTraits().stream().map(t -> t.getTrait().getDisplayName(t.getLevel()).getString()).collect(Collectors.joining(", ")));
        return builder.toString();
    }

    private static void appendTsv(StringBuilder builder, Object value) {
        builder.append(value).append("\t");
    }

    private static ItemStack getGear(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (((CommandSourceStack)ctx.getSource()).m_81373_() instanceof ServerPlayer) {
            ItemStack gear = ((CommandSourceStack)ctx.getSource()).m_81375_().m_21205_();
            if (gear.m_41720_() instanceof ICoreItem) {
                return gear;
            }
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81352_(PartsCommand.text("sourceMustBePlayer", new Object[0]));
        }
        return ItemStack.f_41583_;
    }

    private static Component text(String key, Object ... args) {
        return Component.m_237110_((String)("command.silentgear.parts." + key), (Object[])args);
    }
}

